// NOTE this is a generated file! do not edit!

package clock

import (
	"context"

	"github.com/golang/protobuf/proto"

	eventbus "code.justin.tv/eventbus/client"

	"code.justin.tv/eventbus/schema/pkg/eventbus/authorization"
	"code.justin.tv/eventbus/client/encryption"
)

const (
	UpdateEventType = "ClockUpdate"
)

type Update = ClockUpdate

type ClockUpdateHandler func(context.Context, *eventbus.Header, *ClockUpdate) error

func (h ClockUpdateHandler) Handler() eventbus.Handler {
	return func(ctx context.Context, message eventbus.RawMessage) error {
		dst := &ClockUpdate{}
		err := proto.Unmarshal(message.Payload, dst)
		if err != nil {
			return err
		}
		return h(ctx, message.Header, dst)
	}
}

func RegisterClockUpdateHandler(mux *eventbus.Mux, f ClockUpdateHandler) {
	mux.RegisterHandler(UpdateEventType, f.Handler())
}

func RegisterUpdateHandler(mux *eventbus.Mux, f ClockUpdateHandler) {
	RegisterClockUpdateHandler(mux, f)
}

func (*ClockUpdate) EventBusName() string {
	return UpdateEventType
}
func getClockUpdateClockUpdateSecretFloat32AuthContext(environment string) authorization.Context {
	return authorization.Context{
		authorization.EventType:   "ClockUpdate",
		authorization.Environment: environment,
		authorization.MessageName: "ClockUpdate",
		authorization.FieldName:   "SecretFloat32",
	}
}

func (m *ClockUpdate) SetEncryptedSecretFloat32(p encryption.Provider, plaintext float32) error {
	if m == nil {
		return authorization.ErrEncryptionNilReceiver
	}

	encCtx := getClockUpdateClockUpdateSecretFloat32AuthContext(p.Environment())
	err := authorization.ValidateContext(encCtx)
	if err != nil {
		return err
	}

	enc := p.Encrypter()
	b, err := enc.EncryptFloat32(encCtx, plaintext)
	if err != nil {
		return err
	}
	
	m.SecretFloat32 = &authorization.Float32{
		OlePayload: b,
	}
	return err
}

func (m *ClockUpdate) GetDecryptedSecretFloat32(dec encryption.Decrypter) (float32, error) {
	if m == nil {
		return float32(0), authorization.ErrDecryptionNilReceiver
	}
	if m.GetSecretFloat32() == nil {
		return float32(0), nil
	}
	return dec.DecryptFloat32(m.GetSecretFloat32().GetOlePayload())
}
func getClockUpdateClockUpdateSecretFloat64AuthContext(environment string) authorization.Context {
	return authorization.Context{
		authorization.EventType:   "ClockUpdate",
		authorization.Environment: environment,
		authorization.MessageName: "ClockUpdate",
		authorization.FieldName:   "SecretFloat64",
	}
}

func (m *ClockUpdate) SetEncryptedSecretFloat64(p encryption.Provider, plaintext float64) error {
	if m == nil {
		return authorization.ErrEncryptionNilReceiver
	}

	encCtx := getClockUpdateClockUpdateSecretFloat64AuthContext(p.Environment())
	err := authorization.ValidateContext(encCtx)
	if err != nil {
		return err
	}

	enc := p.Encrypter()
	b, err := enc.EncryptFloat64(encCtx, plaintext)
	if err != nil {
		return err
	}
	
	m.SecretFloat64 = &authorization.Float64{
		OlePayload: b,
	}
	return err
}

func (m *ClockUpdate) GetDecryptedSecretFloat64(dec encryption.Decrypter) (float64, error) {
	if m == nil {
		return float64(0), authorization.ErrDecryptionNilReceiver
	}
	if m.GetSecretFloat64() == nil {
		return float64(0), nil
	}
	return dec.DecryptFloat64(m.GetSecretFloat64().GetOlePayload())
}
func getClockUpdateClockUpdateSecretInt32AuthContext(environment string) authorization.Context {
	return authorization.Context{
		authorization.EventType:   "ClockUpdate",
		authorization.Environment: environment,
		authorization.MessageName: "ClockUpdate",
		authorization.FieldName:   "SecretInt32",
	}
}

func (m *ClockUpdate) SetEncryptedSecretInt32(p encryption.Provider, plaintext int32) error {
	if m == nil {
		return authorization.ErrEncryptionNilReceiver
	}

	encCtx := getClockUpdateClockUpdateSecretInt32AuthContext(p.Environment())
	err := authorization.ValidateContext(encCtx)
	if err != nil {
		return err
	}

	enc := p.Encrypter()
	b, err := enc.EncryptInt32(encCtx, plaintext)
	if err != nil {
		return err
	}
	
	m.SecretInt32 = &authorization.Int32{
		OlePayload: b,
	}
	return err
}

func (m *ClockUpdate) GetDecryptedSecretInt32(dec encryption.Decrypter) (int32, error) {
	if m == nil {
		return int32(0), authorization.ErrDecryptionNilReceiver
	}
	if m.GetSecretInt32() == nil {
		return int32(0), nil
	}
	return dec.DecryptInt32(m.GetSecretInt32().GetOlePayload())
}
func getClockUpdateClockUpdateSecretInt64AuthContext(environment string) authorization.Context {
	return authorization.Context{
		authorization.EventType:   "ClockUpdate",
		authorization.Environment: environment,
		authorization.MessageName: "ClockUpdate",
		authorization.FieldName:   "SecretInt64",
	}
}

func (m *ClockUpdate) SetEncryptedSecretInt64(p encryption.Provider, plaintext int64) error {
	if m == nil {
		return authorization.ErrEncryptionNilReceiver
	}

	encCtx := getClockUpdateClockUpdateSecretInt64AuthContext(p.Environment())
	err := authorization.ValidateContext(encCtx)
	if err != nil {
		return err
	}

	enc := p.Encrypter()
	b, err := enc.EncryptInt64(encCtx, plaintext)
	if err != nil {
		return err
	}
	
	m.SecretInt64 = &authorization.Int64{
		OlePayload: b,
	}
	return err
}

func (m *ClockUpdate) GetDecryptedSecretInt64(dec encryption.Decrypter) (int64, error) {
	if m == nil {
		return int64(0), authorization.ErrDecryptionNilReceiver
	}
	if m.GetSecretInt64() == nil {
		return int64(0), nil
	}
	return dec.DecryptInt64(m.GetSecretInt64().GetOlePayload())
}
func getClockUpdateClockUpdateSecretTimeAuthContext(environment string) authorization.Context {
	return authorization.Context{
		authorization.EventType:   "ClockUpdate",
		authorization.Environment: environment,
		authorization.MessageName: "ClockUpdate",
		authorization.FieldName:   "SecretTime",
	}
}

func (m *ClockUpdate) SetEncryptedSecretTime(p encryption.Provider, plaintext string) error {
	if m == nil {
		return authorization.ErrEncryptionNilReceiver
	}

	encCtx := getClockUpdateClockUpdateSecretTimeAuthContext(p.Environment())
	err := authorization.ValidateContext(encCtx)
	if err != nil {
		return err
	}

	enc := p.Encrypter()
	b, err := enc.EncryptString(encCtx, plaintext)
	if err != nil {
		return err
	}
	
	m.SecretTime = &authorization.String{
		OlePayload: b,
	}
	return err
}

func (m *ClockUpdate) GetDecryptedSecretTime(dec encryption.Decrypter) (string, error) {
	if m == nil {
		return "", authorization.ErrDecryptionNilReceiver
	}
	if m.GetSecretTime() == nil {
		return "", nil
	}
	return dec.DecryptString(m.GetSecretTime().GetOlePayload())
}
