// Code generated by protoc-gen-go. DO NOT EDIT.
// source: commercial/update.proto

package commercial

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "code.justin.tv/eventbus/schema/pkg/eventbus/owner"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The different types of possible commercial formats.
type CommercialType int32

const (
	// An unknown or invalid ad format.
	CommercialType_COMMERCIAL_TYPE_INVALID CommercialType = 0
	// The standard ad format.
	CommercialType_COMMERCIAL_TYPE_STANDARD CommercialType = 1
	// The Picture-By-Picture ad format.
	CommercialType_COMMERCIAL_TYPE_PICTURE_BY_PICTURE CommercialType = 2
	// Auto-ad played in the standard ad format.
	CommercialType_COMMERCIAL_TYPE_AUTO_STANDARD CommercialType = 3
	// Auto-ad played in the Picture-By-Picture ad format.
	CommercialType_COMMERCIAL_TYPE_AUTO_PICTURE_BY_PICTURE CommercialType = 4
)

var CommercialType_name = map[int32]string{
	0: "COMMERCIAL_TYPE_INVALID",
	1: "COMMERCIAL_TYPE_STANDARD",
	2: "COMMERCIAL_TYPE_PICTURE_BY_PICTURE",
	3: "COMMERCIAL_TYPE_AUTO_STANDARD",
	4: "COMMERCIAL_TYPE_AUTO_PICTURE_BY_PICTURE",
}
var CommercialType_value = map[string]int32{
	"COMMERCIAL_TYPE_INVALID":                 0,
	"COMMERCIAL_TYPE_STANDARD":                1,
	"COMMERCIAL_TYPE_PICTURE_BY_PICTURE":      2,
	"COMMERCIAL_TYPE_AUTO_STANDARD":           3,
	"COMMERCIAL_TYPE_AUTO_PICTURE_BY_PICTURE": 4,
}

func (x CommercialType) String() string {
	return proto.EnumName(CommercialType_name, int32(x))
}
func (CommercialType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_update_6d94d9302f23cc62, []int{0}
}

// The different commercial status types that can be returned.
type CommercialStatus int32

const (
	// Indicates an unknown or invalid failure.
	CommercialStatus_COMMERCIAL_STATUS_INVALID CommercialStatus = 0
	// Indicates a commercial was successfully injected into the stream.
	CommercialStatus_COMMERCIAL_STATUS_SUCCESS CommercialStatus = 1
	// Indicates a timeout occurred.
	CommercialStatus_COMMERCIAL_STATUS_TIMEOUT CommercialStatus = 2
	// Indicates a commercial was not successfully injected into the stream.
	CommercialStatus_COMMERCIAL_STATUS_INJECTION_FAILED CommercialStatus = 3
)

var CommercialStatus_name = map[int32]string{
	0: "COMMERCIAL_STATUS_INVALID",
	1: "COMMERCIAL_STATUS_SUCCESS",
	2: "COMMERCIAL_STATUS_TIMEOUT",
	3: "COMMERCIAL_STATUS_INJECTION_FAILED",
}
var CommercialStatus_value = map[string]int32{
	"COMMERCIAL_STATUS_INVALID":          0,
	"COMMERCIAL_STATUS_SUCCESS":          1,
	"COMMERCIAL_STATUS_TIMEOUT":          2,
	"COMMERCIAL_STATUS_INJECTION_FAILED": 3,
}

func (x CommercialStatus) String() string {
	return proto.EnumName(CommercialStatus_name, int32(x))
}
func (CommercialStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_update_6d94d9302f23cc62, []int{1}
}

// CommercialUpdate indicates the status change of an ad request.
// It is triggered when GoTranscode confirms whether or not an ad
// was successfully injected into the stream as an ID3 tag or when
// a timeout occurs.
type CommercialUpdate struct {
	// The ID of the commercial.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The type of requested commercial.
	Type CommercialType `protobuf:"varint,2,opt,name=type,proto3,enum=commercial.CommercialType" json:"type,omitempty"`
	// The user/channel ID of the broadcaster.
	UserId string `protobuf:"bytes,3,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// The duration of the requested commercial in seconds.
	Duration int32 `protobuf:"varint,4,opt,name=duration,proto3" json:"duration,omitempty"`
	// The ID of the user that requested the commercial.
	RequesterUserId string `protobuf:"bytes,5,opt,name=requester_user_id,json=requesterUserId,proto3" json:"requester_user_id,omitempty"`
	// The status of the commercial request.
	Status               CommercialStatus `protobuf:"varint,6,opt,name=status,proto3,enum=commercial.CommercialStatus" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *CommercialUpdate) Reset()         { *m = CommercialUpdate{} }
func (m *CommercialUpdate) String() string { return proto.CompactTextString(m) }
func (*CommercialUpdate) ProtoMessage()    {}
func (*CommercialUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_6d94d9302f23cc62, []int{0}
}
func (m *CommercialUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommercialUpdate.Unmarshal(m, b)
}
func (m *CommercialUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommercialUpdate.Marshal(b, m, deterministic)
}
func (dst *CommercialUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommercialUpdate.Merge(dst, src)
}
func (m *CommercialUpdate) XXX_Size() int {
	return xxx_messageInfo_CommercialUpdate.Size(m)
}
func (m *CommercialUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_CommercialUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_CommercialUpdate proto.InternalMessageInfo

func (m *CommercialUpdate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CommercialUpdate) GetType() CommercialType {
	if m != nil {
		return m.Type
	}
	return CommercialType_COMMERCIAL_TYPE_INVALID
}

func (m *CommercialUpdate) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *CommercialUpdate) GetDuration() int32 {
	if m != nil {
		return m.Duration
	}
	return 0
}

func (m *CommercialUpdate) GetRequesterUserId() string {
	if m != nil {
		return m.RequesterUserId
	}
	return ""
}

func (m *CommercialUpdate) GetStatus() CommercialStatus {
	if m != nil {
		return m.Status
	}
	return CommercialStatus_COMMERCIAL_STATUS_INVALID
}

func init() {
	proto.RegisterType((*CommercialUpdate)(nil), "commercial.CommercialUpdate")
	proto.RegisterEnum("commercial.CommercialType", CommercialType_name, CommercialType_value)
	proto.RegisterEnum("commercial.CommercialStatus", CommercialStatus_name, CommercialStatus_value)
}

func init() { proto.RegisterFile("commercial/update.proto", fileDescriptor_update_6d94d9302f23cc62) }

var fileDescriptor_update_6d94d9302f23cc62 = []byte{
	// 390 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x92, 0xd1, 0x6e, 0x9a, 0x50,
	0x18, 0xc7, 0x77, 0x50, 0x99, 0xfb, 0x62, 0x1c, 0x3b, 0x59, 0x22, 0x73, 0x9a, 0x38, 0x2f, 0x36,
	0xe3, 0x32, 0x4c, 0xb6, 0x5d, 0xed, 0x0e, 0x81, 0x25, 0xa7, 0x51, 0x31, 0x70, 0x68, 0x62, 0x6f,
	0x08, 0xca, 0xb9, 0x20, 0xa9, 0x42, 0xe1, 0xd0, 0xc6, 0x27, 0x69, 0xd2, 0xf7, 0xe8, 0x13, 0xf4,
	0xa1, 0x7a, 0xdb, 0x14, 0x2b, 0x28, 0xe1, 0x8e, 0x93, 0xff, 0xef, 0xff, 0xcb, 0xf7, 0x85, 0x0f,
	0x3a, 0x9b, 0x70, 0xbb, 0x65, 0xf1, 0x26, 0xf0, 0xae, 0x27, 0x69, 0xe4, 0x7b, 0x9c, 0x29, 0x51,
	0x1c, 0xf2, 0x10, 0x43, 0x11, 0x74, 0x3f, 0xb3, 0x5b, 0xb6, 0xe3, 0xeb, 0x34, 0x99, 0x84, 0x77,
	0x3b, 0x16, 0x1f, 0x88, 0xe1, 0x33, 0x02, 0x49, 0xcb, 0x21, 0x27, 0x2b, 0xe3, 0x36, 0x08, 0x81,
	0x2f, 0xa3, 0x01, 0x1a, 0x7d, 0xb0, 0x84, 0xc0, 0xc7, 0x0a, 0xd4, 0xf9, 0x3e, 0x62, 0xb2, 0x30,
	0x40, 0xa3, 0xf6, 0xef, 0xae, 0x52, 0x58, 0x95, 0xa2, 0x4b, 0xf7, 0x11, 0xb3, 0x32, 0x0e, 0x77,
	0xe0, 0x7d, 0x9a, 0xb0, 0xd8, 0x0d, 0x7c, 0xb9, 0x96, 0x49, 0xc4, 0xd7, 0x27, 0xf1, 0x71, 0x17,
	0x9a, 0x7e, 0x1a, 0x7b, 0x3c, 0x08, 0x77, 0x72, 0x7d, 0x80, 0x46, 0x0d, 0x2b, 0x7f, 0xe3, 0x31,
	0x7c, 0x8a, 0xd9, 0x4d, 0xca, 0x12, 0xce, 0x62, 0xf7, 0x58, 0x6f, 0x64, 0xf5, 0x8f, 0x79, 0xe0,
	0x1c, 0x3c, 0x7f, 0x41, 0x4c, 0xb8, 0xc7, 0xd3, 0x44, 0x16, 0xb3, 0x91, 0x7a, 0xd5, 0x23, 0xd9,
	0x19, 0x63, 0xbd, 0xb1, 0xff, 0x5a, 0x0f, 0x8f, 0x72, 0x93, 0x33, 0x6f, 0xfb, 0xcb, 0xf3, 0x93,
	0xf1, 0x13, 0x82, 0xf6, 0xf9, 0xf4, 0xf8, 0x2b, 0x74, 0x34, 0x73, 0x3e, 0x37, 0x2c, 0x8d, 0xa8,
	0x33, 0x97, 0xae, 0x96, 0x86, 0x4b, 0x16, 0x97, 0xea, 0x8c, 0xe8, 0xd2, 0x3b, 0xdc, 0x03, 0xb9,
	0x1c, 0xda, 0x54, 0x5d, 0xe8, 0xaa, 0xa5, 0x4b, 0x08, 0x7f, 0x87, 0x61, 0x39, 0x5d, 0x12, 0x8d,
	0x3a, 0x96, 0xe1, 0x4e, 0x57, 0xc7, 0x4f, 0x49, 0xc0, 0xdf, 0xa0, 0x5f, 0xe6, 0x54, 0x87, 0x9a,
	0x85, 0xaa, 0x86, 0x7f, 0xc2, 0x8f, 0x4a, 0xa4, 0xc2, 0x57, 0x1f, 0xdf, 0x9f, 0xfd, 0xbf, 0xc3,
	0xc2, 0xb8, 0x0f, 0x5f, 0x4e, 0x0c, 0x36, 0x55, 0xa9, 0x63, 0x9f, 0x6c, 0x52, 0x19, 0xdb, 0x8e,
	0xa6, 0x19, 0xb6, 0x2d, 0xa1, 0xea, 0x98, 0x92, 0xb9, 0x61, 0x3a, 0x54, 0x12, 0x4a, 0x9b, 0xe6,
	0xf2, 0x0b, 0x43, 0xa3, 0xc4, 0x5c, 0xb8, 0xff, 0x55, 0x32, 0x33, 0x74, 0xa9, 0x36, 0x6d, 0x5d,
	0x9d, 0x5c, 0xdf, 0x5a, 0xcc, 0xce, 0xed, 0xcf, 0x4b, 0x00, 0x00, 0x00, 0xff, 0xff, 0x39, 0x50,
	0xa0, 0x47, 0xab, 0x02, 0x00, 0x00,
}
