// Code generated by protoc-gen-go. DO NOT EDIT.
// source: entitlement_subscription/create.proto

package entitlement_subscription

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "code.justin.tv/eventbus/schema/pkg/eventbus/owner"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Platform represents the platform on which the entitlement was created.
type Platform int32

const (
	Platform_PLATFORM_INVALID Platform = 0
	Platform_PLATFORM_ANDROID Platform = 1
	Platform_PLATFORM_IOS     Platform = 2
	Platform_PLATFORM_WEB     Platform = 3
)

var Platform_name = map[int32]string{
	0: "PLATFORM_INVALID",
	1: "PLATFORM_ANDROID",
	2: "PLATFORM_IOS",
	3: "PLATFORM_WEB",
}
var Platform_value = map[string]int32{
	"PLATFORM_INVALID": 0,
	"PLATFORM_ANDROID": 1,
	"PLATFORM_IOS":     2,
	"PLATFORM_WEB":     3,
}

func (x Platform) String() string {
	return proto.EnumName(Platform_name, int32(x))
}
func (Platform) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_95c3af93268d99c6, []int{0}
}

// A `SubscriptionType` identifies the method by which a subscription entitlement was created.
type SubscriptionType int32

const (
	SubscriptionType_SUBSCRIPTION_TYPE_INVALID SubscriptionType = 0
	SubscriptionType_SUBSCRIPTION_TYPE_GIFT    SubscriptionType = 1
	SubscriptionType_SUBSCRIPTION_TYPE_PAID    SubscriptionType = 2
	SubscriptionType_SUBSCRIPTION_TYPE_PRIME   SubscriptionType = 3
	// Signifies the user initiated the creation of this entitlement by linking their prime and twitch account.
	// A primelink subscription entitlement is always to the primelink product(s), and not to products owned by real Twitch channels.
	SubscriptionType_SUBSCRIPTION_TYPE_PRIMELINK SubscriptionType = 4
	// Can be a channel's own subscription to themself granted upon reaching Affiliate status, or a subscription created by Twitch internally.
	SubscriptionType_SUBSCRIPTION_TYPE_ADMIN           SubscriptionType = 5
	SubscriptionType_SUBSCRIPTION_TYPE_SUB_TOKEN       SubscriptionType = 6
	SubscriptionType_SUBSCRIPTION_TYPE_CODE_REDEMPTION SubscriptionType = 7
)

var SubscriptionType_name = map[int32]string{
	0: "SUBSCRIPTION_TYPE_INVALID",
	1: "SUBSCRIPTION_TYPE_GIFT",
	2: "SUBSCRIPTION_TYPE_PAID",
	3: "SUBSCRIPTION_TYPE_PRIME",
	4: "SUBSCRIPTION_TYPE_PRIMELINK",
	5: "SUBSCRIPTION_TYPE_ADMIN",
	6: "SUBSCRIPTION_TYPE_SUB_TOKEN",
	7: "SUBSCRIPTION_TYPE_CODE_REDEMPTION",
}
var SubscriptionType_value = map[string]int32{
	"SUBSCRIPTION_TYPE_INVALID":         0,
	"SUBSCRIPTION_TYPE_GIFT":            1,
	"SUBSCRIPTION_TYPE_PAID":            2,
	"SUBSCRIPTION_TYPE_PRIME":           3,
	"SUBSCRIPTION_TYPE_PRIMELINK":       4,
	"SUBSCRIPTION_TYPE_ADMIN":           5,
	"SUBSCRIPTION_TYPE_SUB_TOKEN":       6,
	"SUBSCRIPTION_TYPE_CODE_REDEMPTION": 7,
}

func (x SubscriptionType) String() string {
	return proto.EnumName(SubscriptionType_name, int32(x))
}
func (SubscriptionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_95c3af93268d99c6, []int{1}
}

// EntitlementSubscriptionCreate triggers when a user is successfully entitled for a subscription.
// Note that a subscription can be entitled to start in the future (e.g., gift/prime -> paid conversions, token stacking)
// and can be cancelled before it actually starts.
type EntitlementSubscriptionCreate struct {
	// Entitlement ID
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Twitch User ID of the user who owns this entitlement.
	OwnerUserId string `protobuf:"bytes,2,opt,name=owner_user_id,json=ownerUserId,proto3" json:"owner_user_id,omitempty"`
	// The Platform from which the entitlement came from.
	Platform Platform `protobuf:"varint,3,opt,name=platform,proto3,enum=entitlement_subscription.Platform" json:"platform,omitempty"`
	// ID for the product the user is entitled to.
	ProductId string `protobuf:"bytes,4,opt,name=product_id,json=productId,proto3" json:"product_id,omitempty"`
	// Twitch User ID of the broadcaster who owns the product.
	ProductOwnerUserId string `protobuf:"bytes,5,opt,name=product_owner_user_id,json=productOwnerUserId,proto3" json:"product_owner_user_id,omitempty"`
	// Identifier for the origin object that caused this entitlement.
	OriginId string `protobuf:"bytes,6,opt,name=origin_id,json=originId,proto3" json:"origin_id,omitempty"`
	// When the entitlement starts.
	StartsAt *timestamp.Timestamp `protobuf:"bytes,7,opt,name=starts_at,json=startsAt,proto3" json:"starts_at,omitempty"`
	// When the entitlement expires.
	EndsAt *timestamp.Timestamp `protobuf:"bytes,8,opt,name=ends_at,json=endsAt,proto3" json:"ends_at,omitempty"`
	// The subscription type of this entitlement.
	Type                 SubscriptionType `protobuf:"varint,9,opt,name=type,proto3,enum=entitlement_subscription.SubscriptionType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *EntitlementSubscriptionCreate) Reset()         { *m = EntitlementSubscriptionCreate{} }
func (m *EntitlementSubscriptionCreate) String() string { return proto.CompactTextString(m) }
func (*EntitlementSubscriptionCreate) ProtoMessage()    {}
func (*EntitlementSubscriptionCreate) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_95c3af93268d99c6, []int{0}
}
func (m *EntitlementSubscriptionCreate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntitlementSubscriptionCreate.Unmarshal(m, b)
}
func (m *EntitlementSubscriptionCreate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntitlementSubscriptionCreate.Marshal(b, m, deterministic)
}
func (dst *EntitlementSubscriptionCreate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntitlementSubscriptionCreate.Merge(dst, src)
}
func (m *EntitlementSubscriptionCreate) XXX_Size() int {
	return xxx_messageInfo_EntitlementSubscriptionCreate.Size(m)
}
func (m *EntitlementSubscriptionCreate) XXX_DiscardUnknown() {
	xxx_messageInfo_EntitlementSubscriptionCreate.DiscardUnknown(m)
}

var xxx_messageInfo_EntitlementSubscriptionCreate proto.InternalMessageInfo

func (m *EntitlementSubscriptionCreate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *EntitlementSubscriptionCreate) GetOwnerUserId() string {
	if m != nil {
		return m.OwnerUserId
	}
	return ""
}

func (m *EntitlementSubscriptionCreate) GetPlatform() Platform {
	if m != nil {
		return m.Platform
	}
	return Platform_PLATFORM_INVALID
}

func (m *EntitlementSubscriptionCreate) GetProductId() string {
	if m != nil {
		return m.ProductId
	}
	return ""
}

func (m *EntitlementSubscriptionCreate) GetProductOwnerUserId() string {
	if m != nil {
		return m.ProductOwnerUserId
	}
	return ""
}

func (m *EntitlementSubscriptionCreate) GetOriginId() string {
	if m != nil {
		return m.OriginId
	}
	return ""
}

func (m *EntitlementSubscriptionCreate) GetStartsAt() *timestamp.Timestamp {
	if m != nil {
		return m.StartsAt
	}
	return nil
}

func (m *EntitlementSubscriptionCreate) GetEndsAt() *timestamp.Timestamp {
	if m != nil {
		return m.EndsAt
	}
	return nil
}

func (m *EntitlementSubscriptionCreate) GetType() SubscriptionType {
	if m != nil {
		return m.Type
	}
	return SubscriptionType_SUBSCRIPTION_TYPE_INVALID
}

func init() {
	proto.RegisterType((*EntitlementSubscriptionCreate)(nil), "entitlement_subscription.EntitlementSubscriptionCreate")
	proto.RegisterEnum("entitlement_subscription.Platform", Platform_name, Platform_value)
	proto.RegisterEnum("entitlement_subscription.SubscriptionType", SubscriptionType_name, SubscriptionType_value)
}

func init() {
	proto.RegisterFile("entitlement_subscription/create.proto", fileDescriptor_create_95c3af93268d99c6)
}

var fileDescriptor_create_95c3af93268d99c6 = []byte{
	// 508 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x93, 0xef, 0x6a, 0xda, 0x50,
	0x18, 0xc6, 0x97, 0x68, 0xfd, 0xf3, 0x76, 0x2d, 0x67, 0x87, 0x6e, 0xcb, 0x14, 0xa9, 0x13, 0x0a,
	0x22, 0x2c, 0xb2, 0xf6, 0xc3, 0x60, 0x1f, 0x0a, 0xd1, 0xa4, 0xe3, 0x50, 0x4d, 0x24, 0xc6, 0x8d,
	0xf5, 0x4b, 0x88, 0xe6, 0x54, 0x02, 0x26, 0x27, 0x9c, 0x1c, 0x37, 0x7a, 0x0f, 0xbb, 0x82, 0xdd,
	0xc7, 0xae, 0x60, 0x37, 0x36, 0x3c, 0xea, 0xaa, 0xab, 0x61, 0x1f, 0xf3, 0x3c, 0xbf, 0xe7, 0xbc,
	0x2f, 0xcf, 0x4b, 0xe0, 0x82, 0x26, 0x22, 0x12, 0x0b, 0x1a, 0xd3, 0x44, 0xf8, 0xd9, 0x72, 0x9a,
	0xcd, 0x78, 0x94, 0x8a, 0x88, 0x25, 0xdd, 0x19, 0xa7, 0x81, 0xa0, 0x7a, 0xca, 0x99, 0x60, 0x58,
	0xcb, 0xc3, 0x6a, 0x67, 0xf4, 0x1b, 0x4d, 0xc4, 0x74, 0x99, 0x75, 0xd9, 0xf7, 0x84, 0xf2, 0x35,
	0x5f, 0x3b, 0x9f, 0x33, 0x36, 0x5f, 0xd0, 0xae, 0xfc, 0x9a, 0x2e, 0xef, 0xbb, 0x22, 0x8a, 0x69,
	0x26, 0x82, 0x38, 0x5d, 0x03, 0xad, 0xdf, 0x05, 0x68, 0x58, 0x8f, 0x6f, 0x8e, 0x77, 0x9e, 0xec,
	0xcb, 0xc1, 0xf8, 0x14, 0xd4, 0x28, 0xd4, 0x94, 0xa6, 0xd2, 0xae, 0xba, 0x6a, 0x14, 0xe2, 0x16,
	0x9c, 0xc8, 0x09, 0xfe, 0x32, 0xa3, 0xdc, 0x8f, 0x42, 0x4d, 0x95, 0xd6, 0xb1, 0x14, 0x27, 0x19,
	0xe5, 0x24, 0xc4, 0xd7, 0x50, 0x49, 0x17, 0x81, 0xb8, 0x67, 0x3c, 0xd6, 0x0a, 0x4d, 0xa5, 0x7d,
	0x7a, 0xd9, 0xd2, 0xf3, 0x36, 0xd7, 0x47, 0x1b, 0xd2, 0xfd, 0x9b, 0xc1, 0x0d, 0x80, 0x94, 0xb3,
	0x70, 0x39, 0x13, 0xab, 0x01, 0x45, 0x39, 0xa0, 0xba, 0x51, 0x48, 0x88, 0xdf, 0xc3, 0xcb, 0xad,
	0xbd, 0xbf, 0xca, 0x91, 0x24, 0xf1, 0xc6, 0x74, 0x76, 0x36, 0xaa, 0x43, 0x95, 0xf1, 0x68, 0x1e,
	0x25, 0x2b, 0xac, 0x24, 0xb1, 0xca, 0x5a, 0x20, 0x21, 0xfe, 0x00, 0xd5, 0x4c, 0x04, 0x5c, 0x64,
	0x7e, 0x20, 0xb4, 0x72, 0x53, 0x69, 0x1f, 0x5f, 0xd6, 0xf4, 0x75, 0x73, 0xfa, 0xb6, 0x39, 0xdd,
	0xdb, 0x36, 0xe7, 0x56, 0xd6, 0xb0, 0x21, 0xf0, 0x15, 0x94, 0x69, 0x12, 0xca, 0x58, 0xe5, 0xbf,
	0xb1, 0xd2, 0x0a, 0x35, 0x04, 0xbe, 0x86, 0xa2, 0x78, 0x48, 0xa9, 0x56, 0x95, 0xc5, 0x74, 0xf2,
	0x8b, 0xd9, 0x3d, 0x86, 0xf7, 0x90, 0x52, 0x57, 0xe6, 0x3e, 0xbe, 0xf8, 0xf9, 0x4b, 0x3b, 0x11,
	0x34, 0x88, 0xdf, 0xcd, 0x58, 0x1c, 0x53, 0x3e, 0xa3, 0x9d, 0x3b, 0xa8, 0x6c, 0x5b, 0xc4, 0x67,
	0x80, 0x46, 0x03, 0xc3, 0xbb, 0x71, 0xdc, 0xa1, 0x4f, 0xec, 0xcf, 0xc6, 0x80, 0x98, 0xe8, 0xd9,
	0x9e, 0x6a, 0xd8, 0xa6, 0xeb, 0x10, 0x13, 0x29, 0x18, 0xc1, 0xf3, 0x47, 0xd6, 0x19, 0x23, 0x75,
	0x4f, 0xf9, 0x62, 0xf5, 0x50, 0xa1, 0xf3, 0x43, 0x05, 0xf4, 0xef, 0x26, 0xb8, 0x01, 0x6f, 0xc6,
	0x93, 0xde, 0xb8, 0xef, 0x92, 0x91, 0x47, 0x1c, 0xdb, 0xf7, 0xbe, 0x8e, 0xac, 0x9d, 0x69, 0x35,
	0x78, 0xf5, 0xd4, 0xfe, 0x44, 0x6e, 0x3c, 0xa4, 0x1c, 0xf6, 0x46, 0x06, 0x31, 0x91, 0x8a, 0xeb,
	0xf0, 0xfa, 0x80, 0xe7, 0x92, 0xa1, 0x85, 0x0a, 0xf8, 0x1c, 0xea, 0x39, 0xe6, 0x80, 0xd8, 0xb7,
	0xa8, 0x78, 0x38, 0x6d, 0x98, 0x43, 0x62, 0xa3, 0xa3, 0xc3, 0xe9, 0xf1, 0xa4, 0xe7, 0x7b, 0xce,
	0xad, 0x65, 0xa3, 0x12, 0xbe, 0x80, 0xb7, 0x4f, 0x81, 0xbe, 0x63, 0x5a, 0xbe, 0x6b, 0x99, 0xd6,
	0x50, 0x8a, 0xa8, 0xdc, 0xab, 0xdd, 0xe5, 0xfe, 0x83, 0xd3, 0x92, 0xbc, 0xfa, 0xd5, 0x9f, 0x00,
	0x00, 0x00, 0xff, 0xff, 0x64, 0xf4, 0xc0, 0xd5, 0xcd, 0x03, 0x00, 0x00,
}
