package authorization_test

import (
	"testing"

	"code.justin.tv/eventbus/schema/pkg/eventbus/authorization"
	"github.com/stretchr/testify/assert"
)

func dummyAuthContext() authorization.Context {
	return authorization.Context{
		authorization.EventType:   "FoobarUpdate",
		authorization.Environment: "development",
		authorization.MessageName: "MyGreatAuthorizedField",
		authorization.FieldName:   "MyGreatFieldName",
	}
}

func TestAuthorizationContext(t *testing.T) {
	t.Run("Bad authorization context", func(t *testing.T) {
		t.Run("Normal context", func(t *testing.T) {
			goodContext := dummyAuthContext()
			err := authorization.ValidateContext(goodContext)
			assert.NoError(t, err)
		})
		t.Run("Missing keys", func(t *testing.T) {
			badContext := dummyAuthContext()
			delete(badContext, authorization.Environment)
			err := authorization.ValidateContext(badContext)
			assert.Error(t, err)
		})

		t.Run("Extraneous key", func(t *testing.T) {
			badContext := dummyAuthContext()
			badContext["ThisShouldntBeHere"] = "NeitherShouldThis"
			err := authorization.ValidateContext(badContext)
			assert.Error(t, err)
		})
	})
}
