package change

import (
	"strconv"
	"testing"
)

type Test struct {
	input     []Changeable
	anyoutput bool
	alloutput bool
}

func TestHelpers(t *testing.T) {

	cases := []Test{
		{[]Changeable{}, false, true},
		{[]Changeable{&StringChange{Updated: true}}, true, true},
		{[]Changeable{&StringChange{Updated: false}, &Int64Change{Updated: true}}, true, false},
		{[]Changeable{&StringChange{Updated: false}, &Int64Change{Updated: true}, &Change{Updated: true}}, true, false},
		{[]Changeable{&StringChange{Updated: true}, &Int64Change{Updated: true}, &Change{Updated: true}}, true, true},

		// Make sure the nil variants don't panic
		{[]Changeable{(*Change)(nil)}, false, false},
		{[]Changeable{(*StringChange)(nil)}, false, false},
		{[]Changeable{(*Int64Change)(nil)}, false, false},
	}

	t.Run("AnyChanged", func(t *testing.T) {
		for i, c := range cases {
			t.Run("case "+strconv.Itoa(i), func(t *testing.T) {
				if v := AnyChanged(c.input...); v != c.anyoutput {
					t.Logf("Case %d Expected %v, got %v", i, c.anyoutput, v)
					t.Fail()
				}
			})
		}
	})

	t.Run("AllChanged", func(t *testing.T) {
		for i, c := range cases {
			t.Run("case "+strconv.Itoa(i), func(t *testing.T) {
				if v := AllChanged(c.input...); v != c.alloutput {
					t.Logf("Case %d Expected %v, got %v", i, c.alloutput, v)
					t.Fail()
				}
			})
		}
	})
}
