// Code generated by protoc-gen-go. DO NOT EDIT.
// source: poll/create.proto

package poll

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "code.justin.tv/eventbus/schema/pkg/eventbus/owner"
import duration "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// PollStatus is the different statuses a poll can have.
type PollStatus int32

const (
	PollStatus_POLL_STATUS_INVALID PollStatus = 0
	// Poll is ACTIVE and users can vote.
	PollStatus_POLL_STATUS_ACTIVE PollStatus = 1
	// Poll ran its entire duration and "naturally" completed. Users cannot vote, but results are publicly visible.
	PollStatus_POLL_STATUS_COMPLETED PollStatus = 2
	// Poll was manually terminated by owner before it ran its entire duration. Users cannot vote, but results are publicly visible.
	PollStatus_POLL_STATUS_TERMINATED PollStatus = 3
	// Poll is no longer publicly visible to users.
	PollStatus_POLL_STATUS_ARCHIVED PollStatus = 4
	// Poll is no longer visible to any user on Twitch.
	PollStatus_POLL_STATUS_MODERATED PollStatus = 5
)

var PollStatus_name = map[int32]string{
	0: "POLL_STATUS_INVALID",
	1: "POLL_STATUS_ACTIVE",
	2: "POLL_STATUS_COMPLETED",
	3: "POLL_STATUS_TERMINATED",
	4: "POLL_STATUS_ARCHIVED",
	5: "POLL_STATUS_MODERATED",
}
var PollStatus_value = map[string]int32{
	"POLL_STATUS_INVALID":    0,
	"POLL_STATUS_ACTIVE":     1,
	"POLL_STATUS_COMPLETED":  2,
	"POLL_STATUS_TERMINATED": 3,
	"POLL_STATUS_ARCHIVED":   4,
	"POLL_STATUS_MODERATED":  5,
}

func (x PollStatus) String() string {
	return proto.EnumName(PollStatus_name, int32(x))
}
func (PollStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_21472df3e4c196e4, []int{0}
}

// PollCreate triggers when a new poll is created on a channel.
type PollCreate struct {
	// The polls unique ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The ID of the user who owns the poll.
	OwnedByUserId string `protobuf:"bytes,2,opt,name=owned_by_user_id,json=ownedByUserId,proto3" json:"owned_by_user_id,omitempty"`
	// The title of the poll.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// The settings for the poll.
	Settings *PollSettings `protobuf:"bytes,4,opt,name=settings,proto3" json:"settings,omitempty"`
	// The choices for the poll.
	Choices []*Choice `protobuf:"bytes,5,rep,name=choices,proto3" json:"choices,omitempty"`
	// The duration the poll will run for.
	Duration *duration.Duration `protobuf:"bytes,6,opt,name=duration,proto3" json:"duration,omitempty"`
	// The status of the poll.
	Status PollStatus `protobuf:"varint,7,opt,name=status,proto3,enum=poll.PollStatus" json:"status,omitempty"`
	// Timestamp of when the poll was started.
	StartedAt            *timestamp.Timestamp `protobuf:"bytes,8,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PollCreate) Reset()         { *m = PollCreate{} }
func (m *PollCreate) String() string { return proto.CompactTextString(m) }
func (*PollCreate) ProtoMessage()    {}
func (*PollCreate) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_21472df3e4c196e4, []int{0}
}
func (m *PollCreate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PollCreate.Unmarshal(m, b)
}
func (m *PollCreate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PollCreate.Marshal(b, m, deterministic)
}
func (dst *PollCreate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PollCreate.Merge(dst, src)
}
func (m *PollCreate) XXX_Size() int {
	return xxx_messageInfo_PollCreate.Size(m)
}
func (m *PollCreate) XXX_DiscardUnknown() {
	xxx_messageInfo_PollCreate.DiscardUnknown(m)
}

var xxx_messageInfo_PollCreate proto.InternalMessageInfo

func (m *PollCreate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PollCreate) GetOwnedByUserId() string {
	if m != nil {
		return m.OwnedByUserId
	}
	return ""
}

func (m *PollCreate) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *PollCreate) GetSettings() *PollSettings {
	if m != nil {
		return m.Settings
	}
	return nil
}

func (m *PollCreate) GetChoices() []*Choice {
	if m != nil {
		return m.Choices
	}
	return nil
}

func (m *PollCreate) GetDuration() *duration.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

func (m *PollCreate) GetStatus() PollStatus {
	if m != nil {
		return m.Status
	}
	return PollStatus_POLL_STATUS_INVALID
}

func (m *PollCreate) GetStartedAt() *timestamp.Timestamp {
	if m != nil {
		return m.StartedAt
	}
	return nil
}

// PollSettings contains the information for the settings on the poll.
type PollSettings struct {
	BitsVotes            *PollSettings_BitsVotes          `protobuf:"bytes,1,opt,name=bits_votes,json=bitsVotes,proto3" json:"bits_votes,omitempty"`
	ChannelPointsVotes   *PollSettings_ChannelPointsVotes `protobuf:"bytes,2,opt,name=channel_points_votes,json=channelPointsVotes,proto3" json:"channel_points_votes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *PollSettings) Reset()         { *m = PollSettings{} }
func (m *PollSettings) String() string { return proto.CompactTextString(m) }
func (*PollSettings) ProtoMessage()    {}
func (*PollSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_21472df3e4c196e4, []int{1}
}
func (m *PollSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PollSettings.Unmarshal(m, b)
}
func (m *PollSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PollSettings.Marshal(b, m, deterministic)
}
func (dst *PollSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PollSettings.Merge(dst, src)
}
func (m *PollSettings) XXX_Size() int {
	return xxx_messageInfo_PollSettings.Size(m)
}
func (m *PollSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_PollSettings.DiscardUnknown(m)
}

var xxx_messageInfo_PollSettings proto.InternalMessageInfo

func (m *PollSettings) GetBitsVotes() *PollSettings_BitsVotes {
	if m != nil {
		return m.BitsVotes
	}
	return nil
}

func (m *PollSettings) GetChannelPointsVotes() *PollSettings_ChannelPointsVotes {
	if m != nil {
		return m.ChannelPointsVotes
	}
	return nil
}

// BitsVotes controls whether users can use bits for votes.
type PollSettings_BitsVotes struct {
	// Whether voting with bits is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The cost of bits per vote.
	Cost                 int64    `protobuf:"varint,2,opt,name=cost,proto3" json:"cost,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PollSettings_BitsVotes) Reset()         { *m = PollSettings_BitsVotes{} }
func (m *PollSettings_BitsVotes) String() string { return proto.CompactTextString(m) }
func (*PollSettings_BitsVotes) ProtoMessage()    {}
func (*PollSettings_BitsVotes) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_21472df3e4c196e4, []int{1, 0}
}
func (m *PollSettings_BitsVotes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PollSettings_BitsVotes.Unmarshal(m, b)
}
func (m *PollSettings_BitsVotes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PollSettings_BitsVotes.Marshal(b, m, deterministic)
}
func (dst *PollSettings_BitsVotes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PollSettings_BitsVotes.Merge(dst, src)
}
func (m *PollSettings_BitsVotes) XXX_Size() int {
	return xxx_messageInfo_PollSettings_BitsVotes.Size(m)
}
func (m *PollSettings_BitsVotes) XXX_DiscardUnknown() {
	xxx_messageInfo_PollSettings_BitsVotes.DiscardUnknown(m)
}

var xxx_messageInfo_PollSettings_BitsVotes proto.InternalMessageInfo

func (m *PollSettings_BitsVotes) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *PollSettings_BitsVotes) GetCost() int64 {
	if m != nil {
		return m.Cost
	}
	return 0
}

// ChannelPointsVotes controls whether users can use channel points for votes.
type PollSettings_ChannelPointsVotes struct {
	// Whether boting with channel points is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// The cost of channel points per vote.
	Cost                 int64    `protobuf:"varint,2,opt,name=cost,proto3" json:"cost,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PollSettings_ChannelPointsVotes) Reset()         { *m = PollSettings_ChannelPointsVotes{} }
func (m *PollSettings_ChannelPointsVotes) String() string { return proto.CompactTextString(m) }
func (*PollSettings_ChannelPointsVotes) ProtoMessage()    {}
func (*PollSettings_ChannelPointsVotes) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_21472df3e4c196e4, []int{1, 1}
}
func (m *PollSettings_ChannelPointsVotes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PollSettings_ChannelPointsVotes.Unmarshal(m, b)
}
func (m *PollSettings_ChannelPointsVotes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PollSettings_ChannelPointsVotes.Marshal(b, m, deterministic)
}
func (dst *PollSettings_ChannelPointsVotes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PollSettings_ChannelPointsVotes.Merge(dst, src)
}
func (m *PollSettings_ChannelPointsVotes) XXX_Size() int {
	return xxx_messageInfo_PollSettings_ChannelPointsVotes.Size(m)
}
func (m *PollSettings_ChannelPointsVotes) XXX_DiscardUnknown() {
	xxx_messageInfo_PollSettings_ChannelPointsVotes.DiscardUnknown(m)
}

var xxx_messageInfo_PollSettings_ChannelPointsVotes proto.InternalMessageInfo

func (m *PollSettings_ChannelPointsVotes) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *PollSettings_ChannelPointsVotes) GetCost() int64 {
	if m != nil {
		return m.Cost
	}
	return 0
}

// Choice contains the information for a choice in a poll.
type Choice struct {
	// The choices unique ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The title of the choice.
	Title                string   `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Choice) Reset()         { *m = Choice{} }
func (m *Choice) String() string { return proto.CompactTextString(m) }
func (*Choice) ProtoMessage()    {}
func (*Choice) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_21472df3e4c196e4, []int{2}
}
func (m *Choice) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Choice.Unmarshal(m, b)
}
func (m *Choice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Choice.Marshal(b, m, deterministic)
}
func (dst *Choice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Choice.Merge(dst, src)
}
func (m *Choice) XXX_Size() int {
	return xxx_messageInfo_Choice.Size(m)
}
func (m *Choice) XXX_DiscardUnknown() {
	xxx_messageInfo_Choice.DiscardUnknown(m)
}

var xxx_messageInfo_Choice proto.InternalMessageInfo

func (m *Choice) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Choice) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func init() {
	proto.RegisterType((*PollCreate)(nil), "poll.PollCreate")
	proto.RegisterType((*PollSettings)(nil), "poll.PollSettings")
	proto.RegisterType((*PollSettings_BitsVotes)(nil), "poll.PollSettings.BitsVotes")
	proto.RegisterType((*PollSettings_ChannelPointsVotes)(nil), "poll.PollSettings.ChannelPointsVotes")
	proto.RegisterType((*Choice)(nil), "poll.Choice")
	proto.RegisterEnum("poll.PollStatus", PollStatus_name, PollStatus_value)
}

func init() { proto.RegisterFile("poll/create.proto", fileDescriptor_create_21472df3e4c196e4) }

var fileDescriptor_create_21472df3e4c196e4 = []byte{
	// 551 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x53, 0xcd, 0x6e, 0xd3, 0x40,
	0x18, 0xc4, 0x4e, 0x9a, 0x26, 0x5f, 0x4b, 0xe5, 0x2e, 0x69, 0x71, 0x2d, 0x04, 0x51, 0x24, 0x20,
	0x42, 0xaa, 0x23, 0x05, 0x71, 0x28, 0x9c, 0x12, 0xc7, 0x12, 0x96, 0x92, 0x26, 0xda, 0xb8, 0x41,
	0xe2, 0x62, 0xf9, 0x67, 0x49, 0x57, 0x72, 0xbc, 0x96, 0x77, 0xd3, 0xaa, 0xaf, 0xc2, 0x95, 0x13,
	0x0f, 0xc0, 0x2b, 0xf1, 0x1c, 0xc8, 0xeb, 0x38, 0x32, 0x0d, 0x17, 0x6e, 0xbb, 0x33, 0x93, 0x99,
	0x7c, 0xdf, 0x8e, 0xe1, 0x34, 0x65, 0x71, 0xdc, 0x0f, 0x33, 0xe2, 0x0b, 0x62, 0xa6, 0x19, 0x13,
	0x0c, 0xd5, 0x73, 0xc8, 0x68, 0x93, 0x3b, 0x92, 0x88, 0x60, 0xc3, 0xfb, 0xec, 0x3e, 0x21, 0x59,
	0xc1, 0x19, 0x2f, 0x57, 0x8c, 0xad, 0x62, 0xd2, 0x97, 0xb7, 0x60, 0xf3, 0xad, 0x1f, 0x6d, 0x32,
	0x5f, 0x50, 0x96, 0x6c, 0xf9, 0x57, 0x8f, 0x79, 0x41, 0xd7, 0x84, 0x0b, 0x7f, 0x9d, 0x16, 0x82,
	0xee, 0x6f, 0x15, 0x60, 0xce, 0xe2, 0xd8, 0x92, 0x89, 0xe8, 0x04, 0x54, 0x1a, 0xe9, 0x4a, 0x47,
	0xe9, 0xb5, 0xb0, 0x4a, 0x23, 0xf4, 0x16, 0xb4, 0x3c, 0x2e, 0xf2, 0x82, 0x07, 0x6f, 0xc3, 0x49,
	0xe6, 0xd1, 0x48, 0x57, 0x25, 0xfb, 0x54, 0xe2, 0xa3, 0x87, 0x1b, 0x4e, 0x32, 0x27, 0x42, 0x6d,
	0x38, 0x10, 0x54, 0xc4, 0x44, 0xaf, 0x49, 0xb6, 0xb8, 0x20, 0x13, 0x9a, 0x9c, 0x08, 0x41, 0x93,
	0x15, 0xd7, 0xeb, 0x1d, 0xa5, 0x77, 0x34, 0x40, 0x66, 0x3e, 0x8d, 0x99, 0x47, 0x2e, 0xb6, 0x0c,
	0xde, 0x69, 0xd0, 0x1b, 0x38, 0x0c, 0x6f, 0x19, 0x0d, 0x09, 0xd7, 0x0f, 0x3a, 0xb5, 0xde, 0xd1,
	0xe0, 0xb8, 0x90, 0x5b, 0x12, 0xc4, 0x25, 0x89, 0x3e, 0x40, 0xb3, 0x1c, 0x54, 0x6f, 0x48, 0xdf,
	0x0b, 0xb3, 0x98, 0xd4, 0x2c, 0x27, 0x35, 0xc7, 0x5b, 0x01, 0xde, 0x49, 0x51, 0x0f, 0x1a, 0x5c,
	0xf8, 0x62, 0xc3, 0xf5, 0xc3, 0x8e, 0xd2, 0x3b, 0x19, 0x68, 0x95, 0x3f, 0x23, 0x71, 0xbc, 0xe5,
	0xd1, 0x15, 0x00, 0x17, 0x7e, 0x26, 0x48, 0xe4, 0xf9, 0x42, 0x6f, 0xca, 0x08, 0x63, 0x2f, 0xc2,
	0x2d, 0x97, 0x89, 0x5b, 0x5b, 0xf5, 0x50, 0x7c, 0x3c, 0xfb, 0xfe, 0x4b, 0x3f, 0x15, 0xc4, 0x5f,
	0x5f, 0xa6, 0x2c, 0xa6, 0xf7, 0xfe, 0xea, 0x32, 0xcd, 0x58, 0xd4, 0xfd, 0xa1, 0xc2, 0x71, 0x75,
	0x6a, 0xf4, 0x09, 0x20, 0xa0, 0x82, 0x7b, 0x77, 0x4c, 0x10, 0x2e, 0x57, 0x7e, 0x34, 0x78, 0xb1,
	0xbf, 0x1d, 0x73, 0x44, 0x05, 0x5f, 0xe6, 0x1a, 0xdc, 0x0a, 0xca, 0x23, 0xfa, 0x02, 0xed, 0xf0,
	0xd6, 0x4f, 0x12, 0x12, 0x7b, 0x29, 0xa3, 0xc9, 0xce, 0x46, 0x95, 0x36, 0xaf, 0xff, 0x61, 0x63,
	0x15, 0xf2, 0xb9, 0x54, 0x17, 0x7e, 0x28, 0xdc, 0xc3, 0x8c, 0x2b, 0x68, 0xed, 0x02, 0x91, 0x0e,
	0x87, 0x24, 0xf1, 0x83, 0x98, 0x14, 0x95, 0x68, 0xe2, 0xf2, 0x8a, 0x10, 0xd4, 0x43, 0xc6, 0x85,
	0xcc, 0xab, 0x61, 0x79, 0x36, 0x46, 0x80, 0xf6, 0x43, 0xfe, 0xcf, 0xa3, 0x6b, 0x42, 0xa3, 0x78,
	0xeb, 0xbd, 0x26, 0xee, 0x0a, 0xa6, 0x56, 0x0a, 0xf6, 0xee, 0xa7, 0x52, 0xd4, 0xb7, 0x78, 0x3e,
	0xf4, 0x1c, 0x9e, 0xcd, 0x67, 0x93, 0x89, 0xb7, 0x70, 0x87, 0xee, 0xcd, 0xc2, 0x73, 0xae, 0x97,
	0xc3, 0x89, 0x33, 0xd6, 0x9e, 0xa0, 0x73, 0x40, 0x55, 0x62, 0x68, 0xb9, 0xce, 0xd2, 0xd6, 0x14,
	0x74, 0x01, 0x67, 0x55, 0xdc, 0x9a, 0x4d, 0xe7, 0x13, 0xdb, 0xb5, 0xc7, 0x9a, 0x8a, 0x0c, 0x38,
	0xaf, 0x52, 0xae, 0x8d, 0xa7, 0xce, 0xf5, 0x30, 0xe7, 0x6a, 0x48, 0x87, 0xf6, 0x5f, 0x76, 0xd8,
	0xfa, 0xec, 0x2c, 0xed, 0xb1, 0x56, 0x7f, 0x6c, 0x38, 0x9d, 0x8d, 0x6d, 0x2c, 0x7f, 0x74, 0x30,
	0x6a, 0x7c, 0x95, 0x5f, 0x72, 0xd0, 0x90, 0xfd, 0x79, 0xff, 0x27, 0x00, 0x00, 0xff, 0xff, 0xa8,
	0x26, 0x20, 0xf5, 0xeb, 0x03, 0x00, 0x00,
}
