// Code generated by protoc-gen-go. DO NOT EDIT.
// source: poll/update.proto

package poll

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import change "code.justin.tv/eventbus/schema/pkg/eventbus/change"
import _ "code.justin.tv/eventbus/schema/pkg/eventbus/owner"
import duration "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// PollUpdate triggers when a new poll is updated on a channel.
type PollUpdate struct {
	// The polls unique ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The ID of the user who owns the poll.
	OwnedByUserId string `protobuf:"bytes,2,opt,name=owned_by_user_id,json=ownedByUserId,proto3" json:"owned_by_user_id,omitempty"`
	// The title of the poll.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// The settings for the poll.
	Settings *PollSettings `protobuf:"bytes,4,opt,name=settings,proto3" json:"settings,omitempty"`
	// The choices for the poll.
	Choices []*ChoiceChange `protobuf:"bytes,5,rep,name=choices,proto3" json:"choices,omitempty"`
	// The duration the poll will run for.
	Duration *duration.Duration `protobuf:"bytes,6,opt,name=duration,proto3" json:"duration,omitempty"`
	// The status of the poll.
	Status *PollStatusChange `protobuf:"bytes,7,opt,name=status,proto3" json:"status,omitempty"`
	// Timestamp of when the poll was started.
	StartedAt *timestamp.Timestamp `protobuf:"bytes,8,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	// Timestamp of when the poll was ended. Nil if the poll hasn't ended.
	EndedAt              *change.TimestampChange `protobuf:"bytes,9,opt,name=ended_at,json=endedAt,proto3" json:"ended_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PollUpdate) Reset()         { *m = PollUpdate{} }
func (m *PollUpdate) String() string { return proto.CompactTextString(m) }
func (*PollUpdate) ProtoMessage()    {}
func (*PollUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_2a96078f5d01078e, []int{0}
}
func (m *PollUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PollUpdate.Unmarshal(m, b)
}
func (m *PollUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PollUpdate.Marshal(b, m, deterministic)
}
func (dst *PollUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PollUpdate.Merge(dst, src)
}
func (m *PollUpdate) XXX_Size() int {
	return xxx_messageInfo_PollUpdate.Size(m)
}
func (m *PollUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_PollUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_PollUpdate proto.InternalMessageInfo

func (m *PollUpdate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PollUpdate) GetOwnedByUserId() string {
	if m != nil {
		return m.OwnedByUserId
	}
	return ""
}

func (m *PollUpdate) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *PollUpdate) GetSettings() *PollSettings {
	if m != nil {
		return m.Settings
	}
	return nil
}

func (m *PollUpdate) GetChoices() []*ChoiceChange {
	if m != nil {
		return m.Choices
	}
	return nil
}

func (m *PollUpdate) GetDuration() *duration.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

func (m *PollUpdate) GetStatus() *PollStatusChange {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *PollUpdate) GetStartedAt() *timestamp.Timestamp {
	if m != nil {
		return m.StartedAt
	}
	return nil
}

func (m *PollUpdate) GetEndedAt() *change.TimestampChange {
	if m != nil {
		return m.EndedAt
	}
	return nil
}

// ChoiceChange represents a Choice with the changes to internal fields.
type ChoiceChange struct {
	// The choices unique ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The title of the choice.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// The breakdown of how many votes were cast for the choice.
	Votes *VotesChange `protobuf:"bytes,3,opt,name=votes,proto3" json:"votes,omitempty"`
	// The total number of unique voters for the choice.
	TotalVoters          *change.Int64Change `protobuf:"bytes,4,opt,name=total_voters,json=totalVoters,proto3" json:"total_voters,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ChoiceChange) Reset()         { *m = ChoiceChange{} }
func (m *ChoiceChange) String() string { return proto.CompactTextString(m) }
func (*ChoiceChange) ProtoMessage()    {}
func (*ChoiceChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_2a96078f5d01078e, []int{1}
}
func (m *ChoiceChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChoiceChange.Unmarshal(m, b)
}
func (m *ChoiceChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChoiceChange.Marshal(b, m, deterministic)
}
func (dst *ChoiceChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChoiceChange.Merge(dst, src)
}
func (m *ChoiceChange) XXX_Size() int {
	return xxx_messageInfo_ChoiceChange.Size(m)
}
func (m *ChoiceChange) XXX_DiscardUnknown() {
	xxx_messageInfo_ChoiceChange.DiscardUnknown(m)
}

var xxx_messageInfo_ChoiceChange proto.InternalMessageInfo

func (m *ChoiceChange) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ChoiceChange) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *ChoiceChange) GetVotes() *VotesChange {
	if m != nil {
		return m.Votes
	}
	return nil
}

func (m *ChoiceChange) GetTotalVoters() *change.Int64Change {
	if m != nil {
		return m.TotalVoters
	}
	return nil
}

// VotesChange represents the state change for Votes.
type VotesChange struct {
	Updated              bool     `protobuf:"varint,1,opt,name=updated,proto3" json:"updated,omitempty"`
	Value                *Votes   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	HasOldValue          bool     `protobuf:"varint,3,opt,name=has_old_value,json=hasOldValue,proto3" json:"has_old_value,omitempty"`
	OldValue             *Votes   `protobuf:"bytes,4,opt,name=old_value,json=oldValue,proto3" json:"old_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VotesChange) Reset()         { *m = VotesChange{} }
func (m *VotesChange) String() string { return proto.CompactTextString(m) }
func (*VotesChange) ProtoMessage()    {}
func (*VotesChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_2a96078f5d01078e, []int{2}
}
func (m *VotesChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VotesChange.Unmarshal(m, b)
}
func (m *VotesChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VotesChange.Marshal(b, m, deterministic)
}
func (dst *VotesChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VotesChange.Merge(dst, src)
}
func (m *VotesChange) XXX_Size() int {
	return xxx_messageInfo_VotesChange.Size(m)
}
func (m *VotesChange) XXX_DiscardUnknown() {
	xxx_messageInfo_VotesChange.DiscardUnknown(m)
}

var xxx_messageInfo_VotesChange proto.InternalMessageInfo

func (m *VotesChange) GetUpdated() bool {
	if m != nil {
		return m.Updated
	}
	return false
}

func (m *VotesChange) GetValue() *Votes {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *VotesChange) GetHasOldValue() bool {
	if m != nil {
		return m.HasOldValue
	}
	return false
}

func (m *VotesChange) GetOldValue() *Votes {
	if m != nil {
		return m.OldValue
	}
	return nil
}

// Votes contains the information for the breakdown of votes.
type Votes struct {
	// The total number of votes cast.
	Total int64 `protobuf:"varint,1,opt,name=total,proto3" json:"total,omitempty"`
	// The number of votes cast using bits.
	Bits int64 `protobuf:"varint,2,opt,name=bits,proto3" json:"bits,omitempty"`
	// The number of votes cast using channel points.
	ChannelPoints int64 `protobuf:"varint,3,opt,name=channel_points,json=channelPoints,proto3" json:"channel_points,omitempty"`
	// The number of votes cast using the base free votes.
	Base                 int64    `protobuf:"varint,4,opt,name=base,proto3" json:"base,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Votes) Reset()         { *m = Votes{} }
func (m *Votes) String() string { return proto.CompactTextString(m) }
func (*Votes) ProtoMessage()    {}
func (*Votes) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_2a96078f5d01078e, []int{3}
}
func (m *Votes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Votes.Unmarshal(m, b)
}
func (m *Votes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Votes.Marshal(b, m, deterministic)
}
func (dst *Votes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Votes.Merge(dst, src)
}
func (m *Votes) XXX_Size() int {
	return xxx_messageInfo_Votes.Size(m)
}
func (m *Votes) XXX_DiscardUnknown() {
	xxx_messageInfo_Votes.DiscardUnknown(m)
}

var xxx_messageInfo_Votes proto.InternalMessageInfo

func (m *Votes) GetTotal() int64 {
	if m != nil {
		return m.Total
	}
	return 0
}

func (m *Votes) GetBits() int64 {
	if m != nil {
		return m.Bits
	}
	return 0
}

func (m *Votes) GetChannelPoints() int64 {
	if m != nil {
		return m.ChannelPoints
	}
	return 0
}

func (m *Votes) GetBase() int64 {
	if m != nil {
		return m.Base
	}
	return 0
}

// PollStatusChange represents the state change for a PollStatus.
type PollStatusChange struct {
	Updated              bool       `protobuf:"varint,1,opt,name=updated,proto3" json:"updated,omitempty"`
	Value                PollStatus `protobuf:"varint,2,opt,name=value,proto3,enum=poll.PollStatus" json:"value,omitempty"`
	HasOldValue          bool       `protobuf:"varint,3,opt,name=has_old_value,json=hasOldValue,proto3" json:"has_old_value,omitempty"`
	OldValue             PollStatus `protobuf:"varint,4,opt,name=old_value,json=oldValue,proto3,enum=poll.PollStatus" json:"old_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *PollStatusChange) Reset()         { *m = PollStatusChange{} }
func (m *PollStatusChange) String() string { return proto.CompactTextString(m) }
func (*PollStatusChange) ProtoMessage()    {}
func (*PollStatusChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_2a96078f5d01078e, []int{4}
}
func (m *PollStatusChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PollStatusChange.Unmarshal(m, b)
}
func (m *PollStatusChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PollStatusChange.Marshal(b, m, deterministic)
}
func (dst *PollStatusChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PollStatusChange.Merge(dst, src)
}
func (m *PollStatusChange) XXX_Size() int {
	return xxx_messageInfo_PollStatusChange.Size(m)
}
func (m *PollStatusChange) XXX_DiscardUnknown() {
	xxx_messageInfo_PollStatusChange.DiscardUnknown(m)
}

var xxx_messageInfo_PollStatusChange proto.InternalMessageInfo

func (m *PollStatusChange) GetUpdated() bool {
	if m != nil {
		return m.Updated
	}
	return false
}

func (m *PollStatusChange) GetValue() PollStatus {
	if m != nil {
		return m.Value
	}
	return PollStatus_POLL_STATUS_INVALID
}

func (m *PollStatusChange) GetHasOldValue() bool {
	if m != nil {
		return m.HasOldValue
	}
	return false
}

func (m *PollStatusChange) GetOldValue() PollStatus {
	if m != nil {
		return m.OldValue
	}
	return PollStatus_POLL_STATUS_INVALID
}

func init() {
	proto.RegisterType((*PollUpdate)(nil), "poll.PollUpdate")
	proto.RegisterType((*ChoiceChange)(nil), "poll.ChoiceChange")
	proto.RegisterType((*VotesChange)(nil), "poll.VotesChange")
	proto.RegisterType((*Votes)(nil), "poll.Votes")
	proto.RegisterType((*PollStatusChange)(nil), "poll.PollStatusChange")
}

func init() { proto.RegisterFile("poll/update.proto", fileDescriptor_update_2a96078f5d01078e) }

var fileDescriptor_update_2a96078f5d01078e = []byte{
	// 584 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0x4f, 0x6f, 0xd3, 0x4e,
	0x10, 0x55, 0xe2, 0x24, 0x4d, 0xc6, 0x6d, 0xd5, 0xae, 0xda, 0x9f, 0xfc, 0xab, 0x10, 0x04, 0x4b,
	0xd0, 0x1e, 0xa8, 0x23, 0x85, 0x3f, 0x12, 0x70, 0x40, 0x6d, 0xb9, 0xf4, 0x44, 0x65, 0x68, 0x0f,
	0x5c, 0xac, 0x4d, 0x76, 0x49, 0x2c, 0x6d, 0xbd, 0x96, 0x77, 0xdc, 0xaa, 0xdf, 0x04, 0x71, 0xe0,
	0xca, 0x91, 0x13, 0xdf, 0x0f, 0x79, 0x76, 0xed, 0x5a, 0x09, 0x42, 0xe2, 0x96, 0x79, 0xf3, 0xde,
	0xcc, 0xf3, 0x9b, 0x55, 0x60, 0x37, 0xd7, 0x4a, 0x4d, 0xca, 0x5c, 0x70, 0x94, 0x51, 0x5e, 0x68,
	0xd4, 0xac, 0x57, 0x41, 0x07, 0xfb, 0xf2, 0x46, 0x66, 0x38, 0x2b, 0xcd, 0x64, 0xbe, 0xe4, 0xd9,
	0xc2, 0x35, 0x0f, 0xf6, 0x1a, 0x58, 0xdf, 0x66, 0xb2, 0x70, 0xe8, 0xc3, 0x85, 0xd6, 0x0b, 0x25,
	0x27, 0x54, 0xcd, 0xca, 0x2f, 0x13, 0x51, 0x16, 0x1c, 0x53, 0x9d, 0xb9, 0xfe, 0xa3, 0xd5, 0x3e,
	0xa6, 0xd7, 0xd2, 0x20, 0xbf, 0xce, 0x1d, 0xc1, 0xda, 0x98, 0x17, 0xb2, 0xb1, 0x11, 0xfe, 0xf4,
	0x00, 0x2e, 0xb4, 0x52, 0x97, 0xe4, 0x8d, 0x6d, 0x43, 0x37, 0x15, 0x41, 0x67, 0xdc, 0x39, 0x1a,
	0xc5, 0xdd, 0x54, 0xb0, 0x43, 0xd8, 0xa9, 0x1c, 0x88, 0x64, 0x76, 0x97, 0x94, 0x46, 0x16, 0x49,
	0x2a, 0x82, 0x2e, 0x75, 0xb7, 0x08, 0x3f, 0xbd, 0xbb, 0x34, 0xb2, 0x38, 0x17, 0x6c, 0x0f, 0xfa,
	0x98, 0xa2, 0x92, 0x81, 0x47, 0x5d, 0x5b, 0xb0, 0x08, 0x86, 0x46, 0x22, 0xa6, 0xd9, 0xc2, 0x04,
	0xbd, 0x71, 0xe7, 0xc8, 0x9f, 0xb2, 0xa8, 0xf2, 0x10, 0x55, 0x2b, 0x3f, 0xba, 0x4e, 0xdc, 0x70,
	0xd8, 0x33, 0xd8, 0x98, 0x2f, 0x75, 0x3a, 0x97, 0x26, 0xe8, 0x8f, 0xbd, 0x7b, 0xfa, 0x19, 0x81,
	0x67, 0x14, 0x51, 0x5c, 0x53, 0xd8, 0x4b, 0x18, 0xd6, 0x09, 0x04, 0x03, 0x9a, 0xfe, 0x7f, 0x64,
	0x23, 0x88, 0xea, 0x08, 0xa2, 0xf7, 0x8e, 0x10, 0x37, 0x54, 0x16, 0xc1, 0xc0, 0x20, 0xc7, 0xd2,
	0x04, 0x1b, 0x24, 0xfa, 0xaf, 0x65, 0x89, 0x70, 0xb7, 0xc7, 0xb1, 0xd8, 0x6b, 0x00, 0x83, 0xbc,
	0x40, 0x29, 0x12, 0x8e, 0xc1, 0x90, 0x34, 0x07, 0x6b, 0x8b, 0x3e, 0xd5, 0x59, 0xc7, 0x23, 0xc7,
	0x3e, 0x41, 0xf6, 0x16, 0x86, 0x32, 0x13, 0x56, 0x38, 0x22, 0xe1, 0x38, 0xaa, 0x4f, 0x1b, 0xb9,
	0x8b, 0x37, 0xc2, 0xfa, 0xf3, 0x48, 0x71, 0x82, 0x6f, 0xf6, 0xbf, 0xfd, 0x0a, 0x76, 0x51, 0xf2,
	0xeb, 0xe3, 0x5c, 0xab, 0xf4, 0x96, 0x2f, 0x8e, 0xf3, 0x42, 0x8b, 0xf0, 0x7b, 0x07, 0x36, 0xdb,
	0x79, 0xac, 0xdd, 0xac, 0x39, 0x45, 0xb7, 0x7d, 0x8a, 0x43, 0xe8, 0xdf, 0x68, 0x94, 0x86, 0x0e,
	0xe4, 0x4f, 0x77, 0xed, 0x47, 0x5f, 0x55, 0x90, 0x5b, 0x6c, 0xfb, 0xec, 0x1d, 0x6c, 0xa2, 0x46,
	0xae, 0x92, 0xaa, 0x2c, 0xea, 0xbb, 0x3d, 0x58, 0xf3, 0x7d, 0x9e, 0xe1, 0xab, 0x17, 0x4e, 0xea,
	0x93, 0xe2, 0x8a, 0x04, 0xe1, 0xd7, 0x0e, 0xf8, 0xad, 0xb9, 0x2c, 0x80, 0x0d, 0xfb, 0xf2, 0xad,
	0xc9, 0x61, 0x5c, 0x97, 0xec, 0x31, 0xf4, 0x6f, 0xb8, 0x2a, 0xad, 0x53, 0x7f, 0xea, 0xb7, 0x3c,
	0xc5, 0xb6, 0xc3, 0x42, 0xd8, 0x5a, 0x72, 0x93, 0x68, 0x25, 0x12, 0x4b, 0xf5, 0x68, 0x84, 0xbf,
	0xe4, 0xe6, 0x83, 0x12, 0x57, 0xc4, 0x39, 0x82, 0xd1, 0x7d, 0xbf, 0xb7, 0x3e, 0x6a, 0xa8, 0x1d,
	0x33, 0x54, 0xd0, 0x27, 0x88, 0x32, 0xaa, 0x2c, 0x93, 0x23, 0x2f, 0xb6, 0x05, 0x63, 0xd0, 0x9b,
	0xa5, 0x68, 0xc8, 0x8e, 0x17, 0xd3, 0x6f, 0xf6, 0x04, 0xb6, 0xab, 0x0f, 0xce, 0xa4, 0x4a, 0x72,
	0x9d, 0x66, 0x68, 0x03, 0xf4, 0xe2, 0x2d, 0x87, 0x5e, 0x10, 0x48, 0x52, 0x6e, 0xec, 0xfa, 0x4a,
	0xca, 0x8d, 0x0c, 0x7f, 0x74, 0x60, 0x67, 0xf5, 0x55, 0xfd, 0x25, 0x8d, 0xa7, 0xed, 0x34, 0xb6,
	0xa7, 0x3b, 0xab, 0xcf, 0xf2, 0x5f, 0x22, 0x39, 0x5e, 0x8d, 0xe4, 0x4f, 0xf3, 0x9a, 0x5c, 0x4e,
	0x07, 0x9f, 0xe9, 0xef, 0x68, 0x36, 0xa0, 0xe7, 0xfc, 0xfc, 0x77, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xab, 0x57, 0x3a, 0x06, 0xb0, 0x04, 0x00, 0x00,
}
