// Code generated by protoc-gen-go. DO NOT EDIT.
// source: poll_synchronization/update.proto

package poll_synchronization

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "code.justin.tv/eventbus/schema/pkg/eventbus/owner"
import duration "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// This is the type of poll being updated.
type PollType int32

const (
	// Something went wrong determining the state.
	PollType_POLL_TYPE_INVALID PollType = 0
	// The poll is a channel poll
	PollType_POLL_TYPE_CHANNEL PollType = 1
	// The poll is an ad poll
	PollType_POLL_TYPE_AD PollType = 2
)

var PollType_name = map[int32]string{
	0: "POLL_TYPE_INVALID",
	1: "POLL_TYPE_CHANNEL",
	2: "POLL_TYPE_AD",
}
var PollType_value = map[string]int32{
	"POLL_TYPE_INVALID": 0,
	"POLL_TYPE_CHANNEL": 1,
	"POLL_TYPE_AD":      2,
}

func (x PollType) String() string {
	return proto.EnumName(PollType_name, int32(x))
}
func (PollType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_update_eec2adcd3798a018, []int{0}
}

// This describes what type of update is being made to the poll. This is different than
// the PollStatus in the Poll message, as that describes the current state of the poll
// and not the reason for the eventbus event. They are similar, but are not the same.
type PollSynchronizationUpdateType int32

const (
	// This is not a valid poll update type.
	PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_INVALID PollSynchronizationUpdateType = 0
	// The poll has just been created by the backend service.
	PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_CREATE PollSynchronizationUpdateType = 1
	// The poll was just updated by the backend.
	PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_UPDATE PollSynchronizationUpdateType = 2
	// The poll has just been completed naturally.
	PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_COMPLETE PollSynchronizationUpdateType = 3
	// The poll has been prematurely terminated by something/someone.
	PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_TERMINATE PollSynchronizationUpdateType = 4
	// The poll has been archived so the public can't view it.
	PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_ARCHIVE PollSynchronizationUpdateType = 5
	// The poll has been moderated so nobody can see it.
	PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_MODERATE PollSynchronizationUpdateType = 6
)

var PollSynchronizationUpdateType_name = map[int32]string{
	0: "POLL_SYNCHRONIZATION_UPDATE_TYPE_INVALID",
	1: "POLL_SYNCHRONIZATION_UPDATE_TYPE_CREATE",
	2: "POLL_SYNCHRONIZATION_UPDATE_TYPE_UPDATE",
	3: "POLL_SYNCHRONIZATION_UPDATE_TYPE_COMPLETE",
	4: "POLL_SYNCHRONIZATION_UPDATE_TYPE_TERMINATE",
	5: "POLL_SYNCHRONIZATION_UPDATE_TYPE_ARCHIVE",
	6: "POLL_SYNCHRONIZATION_UPDATE_TYPE_MODERATE",
}
var PollSynchronizationUpdateType_value = map[string]int32{
	"POLL_SYNCHRONIZATION_UPDATE_TYPE_INVALID":   0,
	"POLL_SYNCHRONIZATION_UPDATE_TYPE_CREATE":    1,
	"POLL_SYNCHRONIZATION_UPDATE_TYPE_UPDATE":    2,
	"POLL_SYNCHRONIZATION_UPDATE_TYPE_COMPLETE":  3,
	"POLL_SYNCHRONIZATION_UPDATE_TYPE_TERMINATE": 4,
	"POLL_SYNCHRONIZATION_UPDATE_TYPE_ARCHIVE":   5,
	"POLL_SYNCHRONIZATION_UPDATE_TYPE_MODERATE":  6,
}

func (x PollSynchronizationUpdateType) String() string {
	return proto.EnumName(PollSynchronizationUpdateType_name, int32(x))
}
func (PollSynchronizationUpdateType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_update_eec2adcd3798a018, []int{1}
}

// Status of a poll, describing its lifecycle state.
type Poll_PollStatus int32

const (
	// Something went wrong determining the state :monkaS:.
	Poll_POLL_STATUS_INVALID Poll_PollStatus = 0
	// Poll is ACTIVE and users can vote.
	Poll_POLL_STATUS_ACTIVE Poll_PollStatus = 1
	// Poll ran its entire duration and "naturally" completed. Users cannot
	// vote, but results are publicly visible.
	Poll_POLL_STATUS_COMPLETED Poll_PollStatus = 2
	// Poll was manually terminated by owner before it ran its entire duration.
	// Users cannot vote, but results are publicly visible.
	Poll_POLL_STATUS_TERMINATED Poll_PollStatus = 3
	// Poll is no longer publicly visible to users.
	Poll_POLL_STATUS_ARCHIVED Poll_PollStatus = 4
	// Poll is no longer visible to any user on Twitch.
	Poll_POLL_STATUS_MODERATED Poll_PollStatus = 5
)

var Poll_PollStatus_name = map[int32]string{
	0: "POLL_STATUS_INVALID",
	1: "POLL_STATUS_ACTIVE",
	2: "POLL_STATUS_COMPLETED",
	3: "POLL_STATUS_TERMINATED",
	4: "POLL_STATUS_ARCHIVED",
	5: "POLL_STATUS_MODERATED",
}
var Poll_PollStatus_value = map[string]int32{
	"POLL_STATUS_INVALID":    0,
	"POLL_STATUS_ACTIVE":     1,
	"POLL_STATUS_COMPLETED":  2,
	"POLL_STATUS_TERMINATED": 3,
	"POLL_STATUS_ARCHIVED":   4,
	"POLL_STATUS_MODERATED":  5,
}

func (x Poll_PollStatus) String() string {
	return proto.EnumName(Poll_PollStatus_name, int32(x))
}
func (Poll_PollStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_update_eec2adcd3798a018, []int{1, 0}
}

// PollSynchronizationUpdate triggers when a poll is changed.
type PollSynchronizationUpdate struct {
	// What type of update the poll is receiving
	UpdateType PollSynchronizationUpdateType `protobuf:"varint,1,opt,name=update_type,json=updateType,proto3,enum=poll_synchronization.PollSynchronizationUpdateType" json:"update_type,omitempty"`
	// Type of poll being updated in the event
	PollType PollType `protobuf:"varint,2,opt,name=poll_type,json=pollType,proto3,enum=poll_synchronization.PollType" json:"poll_type,omitempty"`
	// The poll object being updated
	Poll                 *Poll    `protobuf:"bytes,3,opt,name=poll,proto3" json:"poll,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PollSynchronizationUpdate) Reset()         { *m = PollSynchronizationUpdate{} }
func (m *PollSynchronizationUpdate) String() string { return proto.CompactTextString(m) }
func (*PollSynchronizationUpdate) ProtoMessage()    {}
func (*PollSynchronizationUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_eec2adcd3798a018, []int{0}
}
func (m *PollSynchronizationUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PollSynchronizationUpdate.Unmarshal(m, b)
}
func (m *PollSynchronizationUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PollSynchronizationUpdate.Marshal(b, m, deterministic)
}
func (dst *PollSynchronizationUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PollSynchronizationUpdate.Merge(dst, src)
}
func (m *PollSynchronizationUpdate) XXX_Size() int {
	return xxx_messageInfo_PollSynchronizationUpdate.Size(m)
}
func (m *PollSynchronizationUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_PollSynchronizationUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_PollSynchronizationUpdate proto.InternalMessageInfo

func (m *PollSynchronizationUpdate) GetUpdateType() PollSynchronizationUpdateType {
	if m != nil {
		return m.UpdateType
	}
	return PollSynchronizationUpdateType_POLL_SYNCHRONIZATION_UPDATE_TYPE_INVALID
}

func (m *PollSynchronizationUpdate) GetPollType() PollType {
	if m != nil {
		return m.PollType
	}
	return PollType_POLL_TYPE_INVALID
}

func (m *PollSynchronizationUpdate) GetPoll() *Poll {
	if m != nil {
		return m.Poll
	}
	return nil
}

// Information about a poll.
type Poll struct {
	// This is the ID of the poll.
	PollId string `protobuf:"bytes,1,opt,name=poll_id,json=pollId,proto3" json:"poll_id,omitempty"`
	// This is the User/brand who owns the poll.
	OwnerId string `protobuf:"bytes,2,opt,name=owner_id,json=ownerId,proto3" json:"owner_id,omitempty"`
	// This is the title of the poll.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// This is the time the poll starts at.
	StartAt *timestamp.Timestamp `protobuf:"bytes,4,opt,name=start_at,json=startAt,proto3" json:"start_at,omitempty"`
	// Time the poll ends at
	EndAt *timestamp.Timestamp `protobuf:"bytes,5,opt,name=end_at,json=endAt,proto3" json:"end_at,omitempty"`
	// Duration of the poll
	Duration *duration.Duration `protobuf:"bytes,6,opt,name=duration,proto3" json:"duration,omitempty"`
	// Settings for the poll
	Settings *Poll_PollSettings `protobuf:"bytes,7,opt,name=settings,proto3" json:"settings,omitempty"`
	// Current status of the poll
	Status Poll_PollStatus `protobuf:"varint,8,opt,name=status,proto3,enum=poll_synchronization.Poll_PollStatus" json:"status,omitempty"`
	// Information about the choices.
	Choices []*Poll_Choice `protobuf:"bytes,9,rep,name=choices,proto3" json:"choices,omitempty"`
	// A breakdown of how many tokens were spent in the poll.
	TotalVotes int64 `protobuf:"varint,10,opt,name=total_votes,json=totalVotes,proto3" json:"total_votes,omitempty"`
	// Total number of unique voters in the poll. A voter can vote more than
	// once, so the number of votes don't have to match with the number of voters
	TotalVoters int64 `protobuf:"varint,11,opt,name=total_voters,json=totalVoters,proto3" json:"total_voters,omitempty"`
	// Duration remaining before poll completes. This will be nil if the remaining duration is 0 or
	// the poll is over as protobuf will drop what it considers empty.
	RemainingDuration    *duration.Duration `protobuf:"bytes,12,opt,name=remaining_duration,json=remainingDuration,proto3" json:"remaining_duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Poll) Reset()         { *m = Poll{} }
func (m *Poll) String() string { return proto.CompactTextString(m) }
func (*Poll) ProtoMessage()    {}
func (*Poll) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_eec2adcd3798a018, []int{1}
}
func (m *Poll) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Poll.Unmarshal(m, b)
}
func (m *Poll) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Poll.Marshal(b, m, deterministic)
}
func (dst *Poll) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Poll.Merge(dst, src)
}
func (m *Poll) XXX_Size() int {
	return xxx_messageInfo_Poll.Size(m)
}
func (m *Poll) XXX_DiscardUnknown() {
	xxx_messageInfo_Poll.DiscardUnknown(m)
}

var xxx_messageInfo_Poll proto.InternalMessageInfo

func (m *Poll) GetPollId() string {
	if m != nil {
		return m.PollId
	}
	return ""
}

func (m *Poll) GetOwnerId() string {
	if m != nil {
		return m.OwnerId
	}
	return ""
}

func (m *Poll) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Poll) GetStartAt() *timestamp.Timestamp {
	if m != nil {
		return m.StartAt
	}
	return nil
}

func (m *Poll) GetEndAt() *timestamp.Timestamp {
	if m != nil {
		return m.EndAt
	}
	return nil
}

func (m *Poll) GetDuration() *duration.Duration {
	if m != nil {
		return m.Duration
	}
	return nil
}

func (m *Poll) GetSettings() *Poll_PollSettings {
	if m != nil {
		return m.Settings
	}
	return nil
}

func (m *Poll) GetStatus() Poll_PollStatus {
	if m != nil {
		return m.Status
	}
	return Poll_POLL_STATUS_INVALID
}

func (m *Poll) GetChoices() []*Poll_Choice {
	if m != nil {
		return m.Choices
	}
	return nil
}

func (m *Poll) GetTotalVotes() int64 {
	if m != nil {
		return m.TotalVotes
	}
	return 0
}

func (m *Poll) GetTotalVoters() int64 {
	if m != nil {
		return m.TotalVoters
	}
	return 0
}

func (m *Poll) GetRemainingDuration() *duration.Duration {
	if m != nil {
		return m.RemainingDuration
	}
	return nil
}

// Controls settings on the poll.
type Poll_PollSettings struct {
	MultiChoice          *Poll_PollSettings_MultiChoicePollSetting `protobuf:"bytes,1,opt,name=multi_choice,json=multiChoice,proto3" json:"multi_choice,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *Poll_PollSettings) Reset()         { *m = Poll_PollSettings{} }
func (m *Poll_PollSettings) String() string { return proto.CompactTextString(m) }
func (*Poll_PollSettings) ProtoMessage()    {}
func (*Poll_PollSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_eec2adcd3798a018, []int{1, 0}
}
func (m *Poll_PollSettings) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Poll_PollSettings.Unmarshal(m, b)
}
func (m *Poll_PollSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Poll_PollSettings.Marshal(b, m, deterministic)
}
func (dst *Poll_PollSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Poll_PollSettings.Merge(dst, src)
}
func (m *Poll_PollSettings) XXX_Size() int {
	return xxx_messageInfo_Poll_PollSettings.Size(m)
}
func (m *Poll_PollSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_Poll_PollSettings.DiscardUnknown(m)
}

var xxx_messageInfo_Poll_PollSettings proto.InternalMessageInfo

func (m *Poll_PollSettings) GetMultiChoice() *Poll_PollSettings_MultiChoicePollSetting {
	if m != nil {
		return m.MultiChoice
	}
	return nil
}

// Controls whether users can vote for multiple choices.
type Poll_PollSettings_MultiChoicePollSetting struct {
	Enabled              bool     `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Poll_PollSettings_MultiChoicePollSetting) Reset() {
	*m = Poll_PollSettings_MultiChoicePollSetting{}
}
func (m *Poll_PollSettings_MultiChoicePollSetting) String() string { return proto.CompactTextString(m) }
func (*Poll_PollSettings_MultiChoicePollSetting) ProtoMessage()    {}
func (*Poll_PollSettings_MultiChoicePollSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_eec2adcd3798a018, []int{1, 0, 0}
}
func (m *Poll_PollSettings_MultiChoicePollSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Poll_PollSettings_MultiChoicePollSetting.Unmarshal(m, b)
}
func (m *Poll_PollSettings_MultiChoicePollSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Poll_PollSettings_MultiChoicePollSetting.Marshal(b, m, deterministic)
}
func (dst *Poll_PollSettings_MultiChoicePollSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Poll_PollSettings_MultiChoicePollSetting.Merge(dst, src)
}
func (m *Poll_PollSettings_MultiChoicePollSetting) XXX_Size() int {
	return xxx_messageInfo_Poll_PollSettings_MultiChoicePollSetting.Size(m)
}
func (m *Poll_PollSettings_MultiChoicePollSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_Poll_PollSettings_MultiChoicePollSetting.DiscardUnknown(m)
}

var xxx_messageInfo_Poll_PollSettings_MultiChoicePollSetting proto.InternalMessageInfo

func (m *Poll_PollSettings_MultiChoicePollSetting) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// Information about a choice in a poll.
type Poll_Choice struct {
	// ID of the poll choice
	ChoiceId string `protobuf:"bytes,1,opt,name=choice_id,json=choiceId,proto3" json:"choice_id,omitempty"`
	// Title of the choice
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Image url of the poll choice
	ImageUrl string `protobuf:"bytes,3,opt,name=image_url,json=imageUrl,proto3" json:"image_url,omitempty"`
	// A breakdown of how many votes were cast for the choice.
	TotalVotes int64 `protobuf:"varint,4,opt,name=total_votes,json=totalVotes,proto3" json:"total_votes,omitempty"`
	// Total number of unique voters for the choice.
	TotalVoters          int64    `protobuf:"varint,5,opt,name=total_voters,json=totalVoters,proto3" json:"total_voters,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Poll_Choice) Reset()         { *m = Poll_Choice{} }
func (m *Poll_Choice) String() string { return proto.CompactTextString(m) }
func (*Poll_Choice) ProtoMessage()    {}
func (*Poll_Choice) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_eec2adcd3798a018, []int{1, 1}
}
func (m *Poll_Choice) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Poll_Choice.Unmarshal(m, b)
}
func (m *Poll_Choice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Poll_Choice.Marshal(b, m, deterministic)
}
func (dst *Poll_Choice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Poll_Choice.Merge(dst, src)
}
func (m *Poll_Choice) XXX_Size() int {
	return xxx_messageInfo_Poll_Choice.Size(m)
}
func (m *Poll_Choice) XXX_DiscardUnknown() {
	xxx_messageInfo_Poll_Choice.DiscardUnknown(m)
}

var xxx_messageInfo_Poll_Choice proto.InternalMessageInfo

func (m *Poll_Choice) GetChoiceId() string {
	if m != nil {
		return m.ChoiceId
	}
	return ""
}

func (m *Poll_Choice) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Poll_Choice) GetImageUrl() string {
	if m != nil {
		return m.ImageUrl
	}
	return ""
}

func (m *Poll_Choice) GetTotalVotes() int64 {
	if m != nil {
		return m.TotalVotes
	}
	return 0
}

func (m *Poll_Choice) GetTotalVoters() int64 {
	if m != nil {
		return m.TotalVoters
	}
	return 0
}

func init() {
	proto.RegisterType((*PollSynchronizationUpdate)(nil), "poll_synchronization.PollSynchronizationUpdate")
	proto.RegisterType((*Poll)(nil), "poll_synchronization.Poll")
	proto.RegisterType((*Poll_PollSettings)(nil), "poll_synchronization.Poll.PollSettings")
	proto.RegisterType((*Poll_PollSettings_MultiChoicePollSetting)(nil), "poll_synchronization.Poll.PollSettings.MultiChoicePollSetting")
	proto.RegisterType((*Poll_Choice)(nil), "poll_synchronization.Poll.Choice")
	proto.RegisterEnum("poll_synchronization.PollType", PollType_name, PollType_value)
	proto.RegisterEnum("poll_synchronization.PollSynchronizationUpdateType", PollSynchronizationUpdateType_name, PollSynchronizationUpdateType_value)
	proto.RegisterEnum("poll_synchronization.Poll_PollStatus", Poll_PollStatus_name, Poll_PollStatus_value)
}

func init() {
	proto.RegisterFile("poll_synchronization/update.proto", fileDescriptor_update_eec2adcd3798a018)
}

var fileDescriptor_update_eec2adcd3798a018 = []byte{
	// 785 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x55, 0x4d, 0x8f, 0xe2, 0x46,
	0x10, 0x8d, 0xf9, 0x34, 0x65, 0x14, 0x79, 0x3b, 0x2c, 0x6b, 0x58, 0x65, 0x97, 0x19, 0x29, 0x5a,
	0x32, 0xc9, 0x1a, 0x85, 0x55, 0x2e, 0x59, 0x25, 0x92, 0x63, 0x2c, 0xe1, 0x88, 0x2f, 0xf5, 0x18,
	0xa4, 0xdd, 0x8b, 0x65, 0xc6, 0x1d, 0xc6, 0x92, 0xb1, 0x91, 0xdd, 0x9e, 0x68, 0xf2, 0x53, 0xa2,
	0x5c, 0x73, 0xc8, 0x39, 0xca, 0x2f, 0xca, 0x35, 0x3f, 0x62, 0xe5, 0xb6, 0x0d, 0x1e, 0x06, 0x06,
	0x6e, 0x5d, 0xaf, 0xde, 0xab, 0xae, 0x7e, 0x55, 0x18, 0xb8, 0xd8, 0xf8, 0xae, 0x6b, 0x86, 0xf7,
	0xde, 0xcd, 0x6d, 0xe0, 0x7b, 0xce, 0xef, 0x16, 0x75, 0x7c, 0xaf, 0x17, 0x6d, 0x6c, 0x8b, 0x12,
	0x79, 0x13, 0xf8, 0xd4, 0x47, 0x8d, 0x43, 0x94, 0x76, 0x83, 0xdc, 0x11, 0x8f, 0x2e, 0xa3, 0xb0,
	0xe7, 0xff, 0xe6, 0x91, 0x20, 0xe1, 0xb6, 0x5f, 0xad, 0x7c, 0x7f, 0xe5, 0x92, 0x1e, 0x8b, 0x96,
	0xd1, 0xaf, 0x3d, 0x3b, 0x0a, 0x18, 0x3f, 0xcd, 0xbf, 0xde, 0xcf, 0x53, 0x67, 0x4d, 0x42, 0x6a,
	0xad, 0x37, 0x09, 0xe1, 0xf2, 0x7f, 0x0e, 0x5a, 0x33, 0xdf, 0x75, 0xaf, 0x1f, 0x5e, 0x37, 0x67,
	0x0d, 0x21, 0x03, 0x84, 0xa4, 0x35, 0x93, 0xde, 0x6f, 0x88, 0xc4, 0x75, 0xb8, 0xee, 0xe7, 0xfd,
	0x77, 0xf2, 0xa1, 0x06, 0xe5, 0xa3, 0x55, 0x8c, 0xfb, 0x0d, 0xc1, 0x10, 0x6d, 0xcf, 0xe8, 0x3d,
	0xd4, 0x58, 0x05, 0x56, 0xb3, 0xc0, 0x6a, 0xbe, 0x3a, 0x5e, 0x93, 0xc9, 0xf9, 0x4d, 0x7a, 0x42,
	0x32, 0x94, 0xe2, 0xb3, 0x54, 0xec, 0x70, 0x5d, 0xa1, 0xdf, 0x3e, 0xae, 0xc3, 0x8c, 0xf7, 0x43,
	0xfd, 0x8f, 0x7f, 0x25, 0x9e, 0x12, 0x6b, 0xfd, 0xd6, 0xb2, 0xc3, 0xcb, 0x7f, 0x78, 0x28, 0xc5,
	0x49, 0xf4, 0x02, 0xaa, 0x4c, 0xe9, 0xd8, 0xec, 0x55, 0x35, 0x5c, 0x89, 0x43, 0xdd, 0x46, 0x2d,
	0xe0, 0x99, 0xc1, 0x71, 0xa6, 0xc0, 0x32, 0x55, 0x16, 0xeb, 0x36, 0x6a, 0x40, 0x99, 0x3a, 0xd4,
	0x25, 0xec, 0xee, 0x1a, 0x4e, 0x02, 0xf4, 0x3d, 0xf0, 0x21, 0xb5, 0x02, 0x6a, 0x5a, 0x54, 0x2a,
	0xa5, 0x4d, 0x25, 0xae, 0xcb, 0x99, 0xeb, 0xb2, 0x91, 0xb9, 0x8e, 0xab, 0x8c, 0xab, 0x50, 0xf4,
	0x1d, 0x54, 0x88, 0x67, 0xc7, 0xa2, 0xf2, 0x49, 0x51, 0x99, 0x78, 0xb6, 0x42, 0xe3, 0x9b, 0xb2,
	0xf1, 0x4a, 0x15, 0x26, 0x6a, 0x3d, 0x12, 0x0d, 0x52, 0x02, 0xde, 0x52, 0x91, 0x0a, 0x7c, 0x48,
	0x28, 0x75, 0xbc, 0x55, 0x28, 0x55, 0x99, 0xec, 0xcd, 0x71, 0xd7, 0x92, 0x31, 0xa6, 0x74, 0xbc,
	0x15, 0xa2, 0x1f, 0xa1, 0x12, 0x52, 0x8b, 0x46, 0xa1, 0xc4, 0xb3, 0x81, 0x7d, 0x75, 0xaa, 0x04,
	0x23, 0xe3, 0x54, 0x84, 0xde, 0x43, 0xf5, 0xe6, 0xd6, 0x77, 0x6e, 0x48, 0x28, 0xd5, 0x3a, 0xc5,
	0xae, 0xd0, 0xbf, 0x78, 0x42, 0xaf, 0x32, 0x26, 0xce, 0x14, 0xe8, 0x35, 0x08, 0xd4, 0xa7, 0x96,
	0x6b, 0xde, 0xf9, 0x94, 0x84, 0x12, 0x74, 0xb8, 0x6e, 0x11, 0x03, 0x83, 0x16, 0x31, 0x82, 0x2e,
	0xa0, 0xbe, 0x23, 0x04, 0xa1, 0x24, 0x30, 0x86, 0xb0, 0x65, 0x04, 0x21, 0x1a, 0x02, 0x0a, 0xc8,
	0xda, 0x72, 0x3c, 0xc7, 0x5b, 0x99, 0x5b, 0x17, 0xeb, 0xa7, 0x5c, 0x7c, 0xb6, 0x15, 0x65, 0x50,
	0xfb, 0x2f, 0x0e, 0xea, 0x79, 0x93, 0x90, 0x05, 0xf5, 0x75, 0xe4, 0x52, 0xc7, 0x4c, 0xfa, 0x65,
	0xfb, 0x24, 0xf4, 0x7f, 0x3a, 0xd3, 0x63, 0x79, 0x1c, 0x6b, 0x93, 0x27, 0xe7, 0x70, 0x2c, 0xac,
	0x77, 0x78, 0xbb, 0x0f, 0xcd, 0xc3, 0x34, 0x24, 0x41, 0x95, 0x78, 0xd6, 0xd2, 0x25, 0xc9, 0x1e,
	0xf3, 0x38, 0x0b, 0xdb, 0x7f, 0x72, 0x50, 0x49, 0xf8, 0xe8, 0x25, 0xd4, 0x92, 0xde, 0x76, 0xeb,
	0xce, 0x27, 0x40, 0x7e, 0xab, 0x0b, 0xf9, 0xad, 0x7e, 0x09, 0x35, 0x67, 0x6d, 0xad, 0x88, 0x19,
	0x05, 0x6e, 0xba, 0xef, 0x3c, 0x03, 0xe6, 0x81, 0xbb, 0x3f, 0x90, 0xd2, 0xc9, 0x81, 0x94, 0x1f,
	0x0d, 0xe4, 0xf2, 0x6f, 0x0e, 0x60, 0xb7, 0x28, 0xe8, 0x05, 0x7c, 0x31, 0x9b, 0x8e, 0x46, 0xe6,
	0xb5, 0xa1, 0x18, 0xf3, 0x6b, 0x53, 0x9f, 0x2c, 0x94, 0x91, 0x3e, 0x10, 0x3f, 0x43, 0x4d, 0x40,
	0xf9, 0x84, 0xa2, 0x1a, 0xfa, 0x42, 0x13, 0x39, 0xd4, 0x82, 0xe7, 0x79, 0x5c, 0x9d, 0x8e, 0x67,
	0x23, 0xcd, 0xd0, 0x06, 0x62, 0x01, 0xb5, 0xa1, 0x99, 0x4f, 0x19, 0x1a, 0x1e, 0xeb, 0x13, 0x25,
	0xce, 0x15, 0x91, 0x04, 0x8d, 0x07, 0xe5, 0xb0, 0x3a, 0xd4, 0x17, 0xda, 0x40, 0x2c, 0xed, 0x17,
	0x1c, 0x4f, 0x07, 0x1a, 0x66, 0xa2, 0xf2, 0xd5, 0x2f, 0xc0, 0x67, 0x5f, 0x22, 0xf4, 0x1c, 0x9e,
	0x31, 0x9a, 0xf1, 0x61, 0xa6, 0xe5, 0xda, 0x7c, 0x00, 0xab, 0x43, 0x65, 0x32, 0xd1, 0x46, 0x22,
	0x87, 0x44, 0xa8, 0xef, 0x60, 0x65, 0x20, 0x16, 0xae, 0xfe, 0x2b, 0xc0, 0x97, 0x4f, 0x7e, 0x2a,
	0xd1, 0xb7, 0xd0, 0x4d, 0x1a, 0xf9, 0x30, 0x51, 0x87, 0x78, 0x3a, 0xd1, 0x3f, 0x2a, 0x86, 0x3e,
	0x9d, 0x98, 0xf3, 0xd9, 0x40, 0x31, 0xb4, 0xfd, 0x8b, 0xbf, 0x81, 0x37, 0x27, 0xd9, 0x2a, 0xd6,
	0x14, 0x23, 0x36, 0xed, 0x1c, 0x72, 0x72, 0x16, 0x0b, 0xe8, 0x2d, 0x7c, 0x7d, 0xba, 0x72, 0x6a,
	0xbb, 0x58, 0x44, 0x32, 0x5c, 0x9d, 0xa4, 0x6f, 0x47, 0x21, 0x96, 0xce, 0x7a, 0x66, 0x3a, 0x1e,
	0xb1, 0x7c, 0x56, 0x33, 0xd9, 0xc8, 0xc4, 0xca, 0xcf, 0xcd, 0x8f, 0x07, 0xff, 0x45, 0x97, 0x15,
	0xf6, 0x13, 0x7f, 0xf7, 0x29, 0x00, 0x00, 0xff, 0xff, 0x92, 0x9c, 0x6d, 0x70, 0x87, 0x07, 0x00,
	0x00,
}
