// Code generated by protoc-gen-go. DO NOT EDIT.
// source: prediction_event/create.proto

package prediction_event

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "code.justin.tv/eventbus/schema/pkg/eventbus/owner"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// OutcomeColor is the different colors an outcome can have.
type OutcomeColor int32

const (
	OutcomeColor_OUTCOME_COLOR_INVALID OutcomeColor = 0
	// Blue
	OutcomeColor_OUTCOME_COLOR_BLUE OutcomeColor = 1
	// Pink
	OutcomeColor_OUTCOME_COLOR_PINK OutcomeColor = 2
)

var OutcomeColor_name = map[int32]string{
	0: "OUTCOME_COLOR_INVALID",
	1: "OUTCOME_COLOR_BLUE",
	2: "OUTCOME_COLOR_PINK",
}
var OutcomeColor_value = map[string]int32{
	"OUTCOME_COLOR_INVALID": 0,
	"OUTCOME_COLOR_BLUE":    1,
	"OUTCOME_COLOR_PINK":    2,
}

func (x OutcomeColor) String() string {
	return proto.EnumName(OutcomeColor_name, int32(x))
}
func (OutcomeColor) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_223e5d8d7cdb2a19, []int{0}
}

// PredictionEventStatus is the different statuses a prediction event can have.
type PredictionEventStatus int32

const (
	PredictionEventStatus_PREDICTION_EVENT_STATUS_INVALID PredictionEventStatus = 0
	// The prediction event is active and users can make predictions.
	PredictionEventStatus_PREDICTION_EVENT_STATUS_ACTIVE PredictionEventStatus = 1
	// The prediction event has been locked and users can no longer make predictions.
	PredictionEventStatus_PREDICTION_EVENT_STATUS_LOCKED PredictionEventStatus = 2
	// The prediction event has had a winning outcome chosen and the points are being distributed to the users with winning predictions.
	PredictionEventStatus_PREDICTION_EVENT_STATUS_RESOLVE_PENDING PredictionEventStatus = 3
	// The prediction event has had a winning outcome chosen and the points have been distributed to the users with winning predictions.
	PredictionEventStatus_PREDICTION_EVENT_STATUS_RESOLVED PredictionEventStatus = 4
	// The prediction event has been canceled and the points are being refunded to users.
	PredictionEventStatus_PREDICTION_EVENT_STATUS_CANCEL_PENDING PredictionEventStatus = 5
	// The prediction event has been canceled and the points have been refunded to users.
	PredictionEventStatus_PREDICTION_EVENT_STATUS_CANCELED PredictionEventStatus = 6
)

var PredictionEventStatus_name = map[int32]string{
	0: "PREDICTION_EVENT_STATUS_INVALID",
	1: "PREDICTION_EVENT_STATUS_ACTIVE",
	2: "PREDICTION_EVENT_STATUS_LOCKED",
	3: "PREDICTION_EVENT_STATUS_RESOLVE_PENDING",
	4: "PREDICTION_EVENT_STATUS_RESOLVED",
	5: "PREDICTION_EVENT_STATUS_CANCEL_PENDING",
	6: "PREDICTION_EVENT_STATUS_CANCELED",
}
var PredictionEventStatus_value = map[string]int32{
	"PREDICTION_EVENT_STATUS_INVALID":         0,
	"PREDICTION_EVENT_STATUS_ACTIVE":          1,
	"PREDICTION_EVENT_STATUS_LOCKED":          2,
	"PREDICTION_EVENT_STATUS_RESOLVE_PENDING": 3,
	"PREDICTION_EVENT_STATUS_RESOLVED":        4,
	"PREDICTION_EVENT_STATUS_CANCEL_PENDING":  5,
	"PREDICTION_EVENT_STATUS_CANCELED":        6,
}

func (x PredictionEventStatus) String() string {
	return proto.EnumName(PredictionEventStatus_name, int32(x))
}
func (PredictionEventStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_223e5d8d7cdb2a19, []int{1}
}

// PredictionEventCreate triggers when a new prediction event is created on a channel.
type PredictionEventCreate struct {
	// The prediction events unique ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The ID of the channel the prediction event belongs to.
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// The title of the prediction event.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// The outcomes for the prediction event.
	Outcomes []*Outcome `protobuf:"bytes,4,rep,name=outcomes,proto3" json:"outcomes,omitempty"`
	// The window in seconds for users to make predictions on the prediction event.
	PredictionWindowSeconds int64 `protobuf:"varint,5,opt,name=prediction_window_seconds,json=predictionWindowSeconds,proto3" json:"prediction_window_seconds,omitempty"`
	// The status of the prediction event.
	Status PredictionEventStatus `protobuf:"varint,6,opt,name=status,proto3,enum=prediction_event.PredictionEventStatus" json:"status,omitempty"`
	// Timestamp of when the prediction event was created.
	CreatedAt            *timestamp.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PredictionEventCreate) Reset()         { *m = PredictionEventCreate{} }
func (m *PredictionEventCreate) String() string { return proto.CompactTextString(m) }
func (*PredictionEventCreate) ProtoMessage()    {}
func (*PredictionEventCreate) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_223e5d8d7cdb2a19, []int{0}
}
func (m *PredictionEventCreate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictionEventCreate.Unmarshal(m, b)
}
func (m *PredictionEventCreate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictionEventCreate.Marshal(b, m, deterministic)
}
func (dst *PredictionEventCreate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictionEventCreate.Merge(dst, src)
}
func (m *PredictionEventCreate) XXX_Size() int {
	return xxx_messageInfo_PredictionEventCreate.Size(m)
}
func (m *PredictionEventCreate) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictionEventCreate.DiscardUnknown(m)
}

var xxx_messageInfo_PredictionEventCreate proto.InternalMessageInfo

func (m *PredictionEventCreate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PredictionEventCreate) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *PredictionEventCreate) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *PredictionEventCreate) GetOutcomes() []*Outcome {
	if m != nil {
		return m.Outcomes
	}
	return nil
}

func (m *PredictionEventCreate) GetPredictionWindowSeconds() int64 {
	if m != nil {
		return m.PredictionWindowSeconds
	}
	return 0
}

func (m *PredictionEventCreate) GetStatus() PredictionEventStatus {
	if m != nil {
		return m.Status
	}
	return PredictionEventStatus_PREDICTION_EVENT_STATUS_INVALID
}

func (m *PredictionEventCreate) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

// Outcome contains the information for an outcome of the prediction event.
type Outcome struct {
	// The outcomes unique ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The color assigned to the outcome.
	Color OutcomeColor `protobuf:"varint,2,opt,name=color,proto3,enum=prediction_event.OutcomeColor" json:"color,omitempty"`
	// The title of the outcome.
	Title                string   `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Outcome) Reset()         { *m = Outcome{} }
func (m *Outcome) String() string { return proto.CompactTextString(m) }
func (*Outcome) ProtoMessage()    {}
func (*Outcome) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_223e5d8d7cdb2a19, []int{1}
}
func (m *Outcome) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Outcome.Unmarshal(m, b)
}
func (m *Outcome) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Outcome.Marshal(b, m, deterministic)
}
func (dst *Outcome) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Outcome.Merge(dst, src)
}
func (m *Outcome) XXX_Size() int {
	return xxx_messageInfo_Outcome.Size(m)
}
func (m *Outcome) XXX_DiscardUnknown() {
	xxx_messageInfo_Outcome.DiscardUnknown(m)
}

var xxx_messageInfo_Outcome proto.InternalMessageInfo

func (m *Outcome) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Outcome) GetColor() OutcomeColor {
	if m != nil {
		return m.Color
	}
	return OutcomeColor_OUTCOME_COLOR_INVALID
}

func (m *Outcome) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func init() {
	proto.RegisterType((*PredictionEventCreate)(nil), "prediction_event.PredictionEventCreate")
	proto.RegisterType((*Outcome)(nil), "prediction_event.Outcome")
	proto.RegisterEnum("prediction_event.OutcomeColor", OutcomeColor_name, OutcomeColor_value)
	proto.RegisterEnum("prediction_event.PredictionEventStatus", PredictionEventStatus_name, PredictionEventStatus_value)
}

func init() {
	proto.RegisterFile("prediction_event/create.proto", fileDescriptor_create_223e5d8d7cdb2a19)
}

var fileDescriptor_create_223e5d8d7cdb2a19 = []byte{
	// 499 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x93, 0xd1, 0x8e, 0x93, 0x4c,
	0x14, 0xc7, 0x3f, 0xe8, 0xb6, 0xfd, 0xf6, 0xac, 0x69, 0xc8, 0x64, 0xeb, 0xd2, 0x26, 0xee, 0x92,
	0x6a, 0xdc, 0xa6, 0x66, 0x69, 0x52, 0xf5, 0xc2, 0xbd, 0x31, 0x2c, 0x4c, 0x0c, 0x59, 0x84, 0x06,
	0x68, 0x8d, 0xde, 0x10, 0x0a, 0xe3, 0x86, 0xa4, 0x65, 0x1a, 0x18, 0xec, 0xbb, 0xf8, 0x06, 0x3e,
	0x80, 0xef, 0xe3, 0xa3, 0x98, 0x32, 0xdd, 0x6e, 0x2d, 0x76, 0xbd, 0x22, 0xe7, 0x9c, 0x1f, 0xe7,
	0xcf, 0xfc, 0x32, 0xc0, 0xb3, 0x65, 0x46, 0xe2, 0x24, 0x62, 0x09, 0x4d, 0x03, 0xf2, 0x8d, 0xa4,
	0x6c, 0x18, 0x65, 0x24, 0x64, 0x44, 0x5d, 0x66, 0x94, 0x51, 0x24, 0xed, 0x8f, 0xbb, 0xa7, 0xe5,
	0x63, 0x56, 0xe4, 0x43, 0xba, 0x4a, 0x49, 0xc6, 0xb9, 0xee, 0xc5, 0x1d, 0xa5, 0x77, 0x73, 0x32,
	0x2c, 0xab, 0x59, 0xf1, 0x75, 0xc8, 0x92, 0x05, 0xc9, 0x59, 0xb8, 0x58, 0x72, 0xa0, 0xf7, 0x4b,
	0x84, 0xf6, 0x78, 0xbb, 0x0b, 0xaf, 0x77, 0xe8, 0x65, 0x10, 0x6a, 0x81, 0x98, 0xc4, 0xb2, 0xa0,
	0x08, 0xfd, 0x63, 0x57, 0x4c, 0x62, 0x74, 0x06, 0xcd, 0x22, 0x27, 0x59, 0x90, 0xc4, 0xb2, 0x58,
	0x36, 0x1b, 0xeb, 0xd2, 0x8c, 0xd1, 0x29, 0xd4, 0x59, 0xc2, 0xe6, 0x44, 0xae, 0x95, 0x6d, 0x5e,
	0xa0, 0xb7, 0xf0, 0x3f, 0x2d, 0x58, 0x44, 0x17, 0x24, 0x97, 0x8f, 0x94, 0x5a, 0xff, 0x64, 0xd4,
	0x51, 0xf7, 0x3f, 0x5a, 0x75, 0x38, 0xe1, 0x6e, 0x51, 0x74, 0x0d, 0x9d, 0x1d, 0x6a, 0x95, 0xa4,
	0x31, 0x5d, 0x05, 0x39, 0x89, 0x68, 0x1a, 0xe7, 0x72, 0x5d, 0x11, 0xfa, 0x35, 0xf7, 0xec, 0x01,
	0xf8, 0x54, 0xce, 0x3d, 0x3e, 0x46, 0xef, 0xa1, 0x91, 0xb3, 0x90, 0x15, 0xb9, 0xdc, 0x50, 0x84,
	0x7e, 0x6b, 0x74, 0x59, 0x0d, 0xdc, 0x3b, 0xaa, 0x57, 0xe2, 0xee, 0xe6, 0x35, 0xf4, 0x0e, 0x80,
	0x5b, 0x8e, 0x83, 0x90, 0xc9, 0x4d, 0x45, 0xe8, 0x9f, 0x8c, 0xba, 0x2a, 0x57, 0xa8, 0xde, 0x2b,
	0x54, 0xfd, 0x7b, 0x85, 0xee, 0xf1, 0x86, 0xd6, 0xd8, 0x75, 0xe7, 0xfb, 0x4f, 0xb9, 0xcd, 0x48,
	0xb8, 0xb8, 0x7a, 0xc8, 0xcc, 0xaf, 0x96, 0x19, 0x8d, 0x7b, 0x04, 0x9a, 0x9b, 0x73, 0x56, 0x9c,
	0xbe, 0x81, 0x7a, 0x44, 0xe7, 0x34, 0x2b, 0x8d, 0xb6, 0x46, 0xe7, 0x07, 0x0d, 0xe9, 0x6b, 0xca,
	0xe5, 0xf0, 0xdf, 0x85, 0x0f, 0x3e, 0xc3, 0x93, 0x5d, 0x18, 0x75, 0xa0, 0xed, 0x4c, 0x7c, 0xdd,
	0xf9, 0x88, 0x03, 0xdd, 0xb1, 0x1c, 0x37, 0x30, 0xed, 0xa9, 0x66, 0x99, 0x86, 0xf4, 0x1f, 0x7a,
	0x0a, 0xe8, 0xcf, 0xd1, 0x8d, 0x35, 0xc1, 0x92, 0x50, 0xed, 0x8f, 0x4d, 0xfb, 0x56, 0x12, 0x07,
	0x3f, 0xaa, 0x97, 0x84, 0x9b, 0x43, 0xcf, 0xe1, 0x62, 0xec, 0x62, 0xc3, 0xd4, 0x7d, 0xd3, 0xb1,
	0x03, 0x3c, 0xc5, 0xb6, 0x1f, 0x78, 0xbe, 0xe6, 0x4f, 0xbc, 0x9d, 0xb8, 0x1e, 0x9c, 0x1f, 0x82,
	0x34, 0xdd, 0x37, 0xa7, 0xeb, 0xe8, 0x47, 0x18, 0xcb, 0xd1, 0x6f, 0xb1, 0x21, 0x89, 0xe8, 0x15,
	0x5c, 0x1e, 0x62, 0x5c, 0xec, 0x39, 0xd6, 0x14, 0x07, 0x63, 0x6c, 0x1b, 0xa6, 0xfd, 0x41, 0xaa,
	0xa1, 0x17, 0xa0, 0xfc, 0x03, 0x36, 0xa4, 0x23, 0x34, 0x80, 0x97, 0x87, 0x28, 0x5d, 0xb3, 0x75,
	0x6c, 0x6d, 0x37, 0xd6, 0x1f, 0xdb, 0xc8, 0x59, 0x6c, 0x48, 0x8d, 0x1b, 0xf4, 0xa5, 0xf2, 0x6f,
	0xce, 0x1a, 0xe5, 0xdd, 0x79, 0xfd, 0x3b, 0x00, 0x00, 0xff, 0xff, 0x05, 0xa2, 0xea, 0xde, 0xd5,
	0x03, 0x00, 0x00,
}
