// Code generated by protoc-gen-go. DO NOT EDIT.
// source: prediction_event/update.proto

package prediction_event

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import change "code.justin.tv/eventbus/schema/pkg/eventbus/change"
import _ "code.justin.tv/eventbus/schema/pkg/eventbus/owner"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// PredictionResultType is the different results that a prediction can have.
type PredictionResultType int32

const (
	PredictionResultType_PREDICTION_RESULT_TYPE_INVALID PredictionResultType = 0
	// The prediction has been refunded.
	PredictionResultType_PREDICTION_RESULT_TYPE_REFUND PredictionResultType = 1
	// The prediction won.
	PredictionResultType_PREDICTION_RESULT_TYPE_WIN PredictionResultType = 2
	// The prediction lost.
	PredictionResultType_PREDICTION_RESULT_TYPE_LOSE PredictionResultType = 3
)

var PredictionResultType_name = map[int32]string{
	0: "PREDICTION_RESULT_TYPE_INVALID",
	1: "PREDICTION_RESULT_TYPE_REFUND",
	2: "PREDICTION_RESULT_TYPE_WIN",
	3: "PREDICTION_RESULT_TYPE_LOSE",
}
var PredictionResultType_value = map[string]int32{
	"PREDICTION_RESULT_TYPE_INVALID": 0,
	"PREDICTION_RESULT_TYPE_REFUND":  1,
	"PREDICTION_RESULT_TYPE_WIN":     2,
	"PREDICTION_RESULT_TYPE_LOSE":    3,
}

func (x PredictionResultType) String() string {
	return proto.EnumName(PredictionResultType_name, int32(x))
}
func (PredictionResultType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_update_bf4c818b65293b9c, []int{0}
}

// PredictionEventUpdate triggers when a prediction event is updated on a channel.
type PredictionEventUpdate struct {
	// The prediction events unique ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The ID of the channel the prediction event belongs to.
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// The title of the prediction event.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// The outcomes for the prediction event.
	Outcomes []*OutcomeChange `protobuf:"bytes,4,rep,name=outcomes,proto3" json:"outcomes,omitempty"`
	// The window in seconds for users to make predictions on the prediction event.
	PredictionWindowSeconds int64 `protobuf:"varint,5,opt,name=prediction_window_seconds,json=predictionWindowSeconds,proto3" json:"prediction_window_seconds,omitempty"`
	// The status of the prediction event.
	Status *PredictionEventStatusChange `protobuf:"bytes,6,opt,name=status,proto3" json:"status,omitempty"`
	// The ID of the winning outcome. Nil if a winning outcome hasn't been chosen.
	WinningOutcomeId *change.StringValueChange `protobuf:"bytes,7,opt,name=winning_outcome_id,json=winningOutcomeId,proto3" json:"winning_outcome_id,omitempty"`
	// Timestamp of when the prediction event was created.
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,8,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Timestamp of when the prediction event was locked. Nil if the prediction event hasn't been locked.
	LockedAt *change.TimestampChange `protobuf:"bytes,9,opt,name=locked_at,json=lockedAt,proto3" json:"locked_at,omitempty"`
	// Timestamp of when the prediction event ended. Nil if the prediction event hasn't ended.
	EndedAt              *change.TimestampChange `protobuf:"bytes,10,opt,name=ended_at,json=endedAt,proto3" json:"ended_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PredictionEventUpdate) Reset()         { *m = PredictionEventUpdate{} }
func (m *PredictionEventUpdate) String() string { return proto.CompactTextString(m) }
func (*PredictionEventUpdate) ProtoMessage()    {}
func (*PredictionEventUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_bf4c818b65293b9c, []int{0}
}
func (m *PredictionEventUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictionEventUpdate.Unmarshal(m, b)
}
func (m *PredictionEventUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictionEventUpdate.Marshal(b, m, deterministic)
}
func (dst *PredictionEventUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictionEventUpdate.Merge(dst, src)
}
func (m *PredictionEventUpdate) XXX_Size() int {
	return xxx_messageInfo_PredictionEventUpdate.Size(m)
}
func (m *PredictionEventUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictionEventUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_PredictionEventUpdate proto.InternalMessageInfo

func (m *PredictionEventUpdate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PredictionEventUpdate) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *PredictionEventUpdate) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *PredictionEventUpdate) GetOutcomes() []*OutcomeChange {
	if m != nil {
		return m.Outcomes
	}
	return nil
}

func (m *PredictionEventUpdate) GetPredictionWindowSeconds() int64 {
	if m != nil {
		return m.PredictionWindowSeconds
	}
	return 0
}

func (m *PredictionEventUpdate) GetStatus() *PredictionEventStatusChange {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *PredictionEventUpdate) GetWinningOutcomeId() *change.StringValueChange {
	if m != nil {
		return m.WinningOutcomeId
	}
	return nil
}

func (m *PredictionEventUpdate) GetCreatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *PredictionEventUpdate) GetLockedAt() *change.TimestampChange {
	if m != nil {
		return m.LockedAt
	}
	return nil
}

func (m *PredictionEventUpdate) GetEndedAt() *change.TimestampChange {
	if m != nil {
		return m.EndedAt
	}
	return nil
}

// OutcomeChange represents an Outcome with the changes to internal fields.
type OutcomeChange struct {
	// The outcomes unique ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The color assigned to the outcome.
	Color OutcomeColor `protobuf:"varint,2,opt,name=color,proto3,enum=prediction_event.OutcomeColor" json:"color,omitempty"`
	// The title of the outcome.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// The total points used on the outcome.
	TotalPoints *change.Int64Change `protobuf:"bytes,4,opt,name=total_points,json=totalPoints,proto3" json:"total_points,omitempty"`
	// The total users who selected the outcome.
	TotalUsers *change.Int64Change `protobuf:"bytes,5,opt,name=total_users,json=totalUsers,proto3" json:"total_users,omitempty"`
	// The predictions of the top predictors by points used on the outcome.
	TopPredictors        *PredictionArrayChange `protobuf:"bytes,6,opt,name=top_predictors,json=topPredictors,proto3" json:"top_predictors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *OutcomeChange) Reset()         { *m = OutcomeChange{} }
func (m *OutcomeChange) String() string { return proto.CompactTextString(m) }
func (*OutcomeChange) ProtoMessage()    {}
func (*OutcomeChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_bf4c818b65293b9c, []int{1}
}
func (m *OutcomeChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutcomeChange.Unmarshal(m, b)
}
func (m *OutcomeChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutcomeChange.Marshal(b, m, deterministic)
}
func (dst *OutcomeChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutcomeChange.Merge(dst, src)
}
func (m *OutcomeChange) XXX_Size() int {
	return xxx_messageInfo_OutcomeChange.Size(m)
}
func (m *OutcomeChange) XXX_DiscardUnknown() {
	xxx_messageInfo_OutcomeChange.DiscardUnknown(m)
}

var xxx_messageInfo_OutcomeChange proto.InternalMessageInfo

func (m *OutcomeChange) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *OutcomeChange) GetColor() OutcomeColor {
	if m != nil {
		return m.Color
	}
	return OutcomeColor_OUTCOME_COLOR_INVALID
}

func (m *OutcomeChange) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *OutcomeChange) GetTotalPoints() *change.Int64Change {
	if m != nil {
		return m.TotalPoints
	}
	return nil
}

func (m *OutcomeChange) GetTotalUsers() *change.Int64Change {
	if m != nil {
		return m.TotalUsers
	}
	return nil
}

func (m *OutcomeChange) GetTopPredictors() *PredictionArrayChange {
	if m != nil {
		return m.TopPredictors
	}
	return nil
}

// PredictionArrayChange represents the state change for an array of Predictions.
type PredictionArrayChange struct {
	Updated              bool          `protobuf:"varint,1,opt,name=updated,proto3" json:"updated,omitempty"`
	Value                []*Prediction `protobuf:"bytes,2,rep,name=value,proto3" json:"value,omitempty"`
	HasOldValue          bool          `protobuf:"varint,3,opt,name=has_old_value,json=hasOldValue,proto3" json:"has_old_value,omitempty"`
	OldValue             []*Prediction `protobuf:"bytes,4,rep,name=old_value,json=oldValue,proto3" json:"old_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *PredictionArrayChange) Reset()         { *m = PredictionArrayChange{} }
func (m *PredictionArrayChange) String() string { return proto.CompactTextString(m) }
func (*PredictionArrayChange) ProtoMessage()    {}
func (*PredictionArrayChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_bf4c818b65293b9c, []int{2}
}
func (m *PredictionArrayChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictionArrayChange.Unmarshal(m, b)
}
func (m *PredictionArrayChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictionArrayChange.Marshal(b, m, deterministic)
}
func (dst *PredictionArrayChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictionArrayChange.Merge(dst, src)
}
func (m *PredictionArrayChange) XXX_Size() int {
	return xxx_messageInfo_PredictionArrayChange.Size(m)
}
func (m *PredictionArrayChange) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictionArrayChange.DiscardUnknown(m)
}

var xxx_messageInfo_PredictionArrayChange proto.InternalMessageInfo

func (m *PredictionArrayChange) GetUpdated() bool {
	if m != nil {
		return m.Updated
	}
	return false
}

func (m *PredictionArrayChange) GetValue() []*Prediction {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *PredictionArrayChange) GetHasOldValue() bool {
	if m != nil {
		return m.HasOldValue
	}
	return false
}

func (m *PredictionArrayChange) GetOldValue() []*Prediction {
	if m != nil {
		return m.OldValue
	}
	return nil
}

// Prediction contains the information for a users prediction in a prediction event.
type Prediction struct {
	// The predictions unique ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The ID of the user who made the prediction.
	UserId string `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// The number of points used by the user.
	Points int64 `protobuf:"varint,3,opt,name=points,proto3" json:"points,omitempty"`
	// The result of the prediction. Nil if the prediction event hasn't ended yet.
	Result               *PredictionResult `protobuf:"bytes,4,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Prediction) Reset()         { *m = Prediction{} }
func (m *Prediction) String() string { return proto.CompactTextString(m) }
func (*Prediction) ProtoMessage()    {}
func (*Prediction) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_bf4c818b65293b9c, []int{3}
}
func (m *Prediction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Prediction.Unmarshal(m, b)
}
func (m *Prediction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Prediction.Marshal(b, m, deterministic)
}
func (dst *Prediction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Prediction.Merge(dst, src)
}
func (m *Prediction) XXX_Size() int {
	return xxx_messageInfo_Prediction.Size(m)
}
func (m *Prediction) XXX_DiscardUnknown() {
	xxx_messageInfo_Prediction.DiscardUnknown(m)
}

var xxx_messageInfo_Prediction proto.InternalMessageInfo

func (m *Prediction) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Prediction) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *Prediction) GetPoints() int64 {
	if m != nil {
		return m.Points
	}
	return 0
}

func (m *Prediction) GetResult() *PredictionResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// PredictionResult contains the information for the result of a users prediction in a prediction event.
type PredictionResult struct {
	// The type of result.
	Type PredictionResultType `protobuf:"varint,1,opt,name=type,proto3,enum=prediction_event.PredictionResultType" json:"type,omitempty"`
	// The amount of points won based on the result of the prediction. Nil if the prediction event hasn't ended or the prediction wasn't won.
	PointsWon            *wrappers.Int64Value `protobuf:"bytes,2,opt,name=points_won,json=pointsWon,proto3" json:"points_won,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PredictionResult) Reset()         { *m = PredictionResult{} }
func (m *PredictionResult) String() string { return proto.CompactTextString(m) }
func (*PredictionResult) ProtoMessage()    {}
func (*PredictionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_bf4c818b65293b9c, []int{4}
}
func (m *PredictionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictionResult.Unmarshal(m, b)
}
func (m *PredictionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictionResult.Marshal(b, m, deterministic)
}
func (dst *PredictionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictionResult.Merge(dst, src)
}
func (m *PredictionResult) XXX_Size() int {
	return xxx_messageInfo_PredictionResult.Size(m)
}
func (m *PredictionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictionResult.DiscardUnknown(m)
}

var xxx_messageInfo_PredictionResult proto.InternalMessageInfo

func (m *PredictionResult) GetType() PredictionResultType {
	if m != nil {
		return m.Type
	}
	return PredictionResultType_PREDICTION_RESULT_TYPE_INVALID
}

func (m *PredictionResult) GetPointsWon() *wrappers.Int64Value {
	if m != nil {
		return m.PointsWon
	}
	return nil
}

// PredictionEventStatusChange represents the state change for a PredictionEventStatus.
type PredictionEventStatusChange struct {
	Updated              bool                  `protobuf:"varint,1,opt,name=updated,proto3" json:"updated,omitempty"`
	Value                PredictionEventStatus `protobuf:"varint,2,opt,name=value,proto3,enum=prediction_event.PredictionEventStatus" json:"value,omitempty"`
	HasOldValue          bool                  `protobuf:"varint,3,opt,name=has_old_value,json=hasOldValue,proto3" json:"has_old_value,omitempty"`
	OldValue             PredictionEventStatus `protobuf:"varint,4,opt,name=old_value,json=oldValue,proto3,enum=prediction_event.PredictionEventStatus" json:"old_value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PredictionEventStatusChange) Reset()         { *m = PredictionEventStatusChange{} }
func (m *PredictionEventStatusChange) String() string { return proto.CompactTextString(m) }
func (*PredictionEventStatusChange) ProtoMessage()    {}
func (*PredictionEventStatusChange) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_bf4c818b65293b9c, []int{5}
}
func (m *PredictionEventStatusChange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictionEventStatusChange.Unmarshal(m, b)
}
func (m *PredictionEventStatusChange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictionEventStatusChange.Marshal(b, m, deterministic)
}
func (dst *PredictionEventStatusChange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictionEventStatusChange.Merge(dst, src)
}
func (m *PredictionEventStatusChange) XXX_Size() int {
	return xxx_messageInfo_PredictionEventStatusChange.Size(m)
}
func (m *PredictionEventStatusChange) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictionEventStatusChange.DiscardUnknown(m)
}

var xxx_messageInfo_PredictionEventStatusChange proto.InternalMessageInfo

func (m *PredictionEventStatusChange) GetUpdated() bool {
	if m != nil {
		return m.Updated
	}
	return false
}

func (m *PredictionEventStatusChange) GetValue() PredictionEventStatus {
	if m != nil {
		return m.Value
	}
	return PredictionEventStatus_PREDICTION_EVENT_STATUS_INVALID
}

func (m *PredictionEventStatusChange) GetHasOldValue() bool {
	if m != nil {
		return m.HasOldValue
	}
	return false
}

func (m *PredictionEventStatusChange) GetOldValue() PredictionEventStatus {
	if m != nil {
		return m.OldValue
	}
	return PredictionEventStatus_PREDICTION_EVENT_STATUS_INVALID
}

func init() {
	proto.RegisterType((*PredictionEventUpdate)(nil), "prediction_event.PredictionEventUpdate")
	proto.RegisterType((*OutcomeChange)(nil), "prediction_event.OutcomeChange")
	proto.RegisterType((*PredictionArrayChange)(nil), "prediction_event.PredictionArrayChange")
	proto.RegisterType((*Prediction)(nil), "prediction_event.Prediction")
	proto.RegisterType((*PredictionResult)(nil), "prediction_event.PredictionResult")
	proto.RegisterType((*PredictionEventStatusChange)(nil), "prediction_event.PredictionEventStatusChange")
	proto.RegisterEnum("prediction_event.PredictionResultType", PredictionResultType_name, PredictionResultType_value)
}

func init() {
	proto.RegisterFile("prediction_event/update.proto", fileDescriptor_update_bf4c818b65293b9c)
}

var fileDescriptor_update_bf4c818b65293b9c = []byte{
	// 787 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0xdd, 0x6e, 0xda, 0x4a,
	0x10, 0x3e, 0xe6, 0x9f, 0xe1, 0x04, 0xa1, 0x55, 0x72, 0xe2, 0x90, 0x84, 0x70, 0x7c, 0x71, 0x82,
	0x8e, 0x14, 0x23, 0xd1, 0xa8, 0x52, 0xa8, 0xa2, 0x8a, 0x06, 0x2a, 0x59, 0x8a, 0x00, 0x19, 0x48,
	0xd4, 0xde, 0x58, 0x0e, 0xde, 0x12, 0xab, 0xc6, 0x6b, 0xd9, 0xeb, 0xa0, 0x3c, 0x42, 0xfb, 0x08,
	0xbd, 0xe8, 0x5b, 0xf4, 0xa6, 0xbd, 0xed, 0x83, 0xf4, 0x51, 0x2a, 0xef, 0x2e, 0x90, 0x40, 0x21,
	0xe4, 0x0a, 0xcd, 0xce, 0xf7, 0x8d, 0x67, 0xe6, 0xfb, 0x76, 0x81, 0x43, 0xcf, 0xc7, 0x96, 0x3d,
	0xa4, 0x36, 0x71, 0x0d, 0x7c, 0x87, 0x5d, 0x5a, 0x0d, 0x3d, 0xcb, 0xa4, 0x58, 0xf5, 0x7c, 0x42,
	0x09, 0x2a, 0x2c, 0xa6, 0x8b, 0x3b, 0xec, 0xe7, 0x26, 0x0c, 0xaa, 0xc3, 0x5b, 0xd3, 0x1d, 0x09,
	0x60, 0x71, 0x7b, 0x76, 0x4c, 0x26, 0x2e, 0xf6, 0xc5, 0xe9, 0xd1, 0x88, 0x90, 0x91, 0x83, 0xab,
	0x2c, 0xba, 0x09, 0x3f, 0x54, 0xa9, 0x3d, 0xc6, 0x01, 0x35, 0xc7, 0x9e, 0x00, 0x94, 0x16, 0x01,
	0x13, 0xdf, 0xf4, 0x3c, 0xec, 0x07, 0x22, 0xbf, 0xdc, 0xde, 0xd0, 0xc7, 0xb3, 0xf6, 0x94, 0xef,
	0x09, 0xd8, 0xe9, 0xce, 0x10, 0xad, 0x08, 0x30, 0x60, 0xed, 0xa3, 0x3c, 0xc4, 0x6c, 0x4b, 0x96,
	0xca, 0x52, 0x25, 0xab, 0xc7, 0x6c, 0x0b, 0xed, 0x42, 0x3a, 0x0c, 0xb0, 0x6f, 0xd8, 0x96, 0x1c,
	0x63, 0x87, 0xa9, 0x28, 0xd4, 0x2c, 0xb4, 0x0d, 0x49, 0x6a, 0x53, 0x07, 0xcb, 0x71, 0x76, 0xcc,
	0x03, 0xf4, 0x0a, 0x32, 0x24, 0xa4, 0x43, 0x32, 0xc6, 0x81, 0x9c, 0x28, 0xc7, 0x2b, 0xb9, 0xda,
	0x91, 0xba, 0xd8, 0x8a, 0xda, 0xe1, 0x88, 0x0b, 0xb6, 0x07, 0x7d, 0x46, 0x40, 0x75, 0xd8, 0x7b,
	0x80, 0x9d, 0xd8, 0xae, 0x45, 0x26, 0x46, 0x80, 0x87, 0xc4, 0xb5, 0x02, 0x39, 0x59, 0x96, 0x2a,
	0x71, 0x7d, 0x77, 0x0e, 0xb8, 0x66, 0xf9, 0x1e, 0x4f, 0xa3, 0x16, 0xa4, 0x02, 0x6a, 0xd2, 0x30,
	0x90, 0x53, 0x65, 0xa9, 0x92, 0xab, 0x9d, 0x2c, 0x7f, 0x76, 0x61, 0xe0, 0x1e, 0x83, 0x8b, 0x26,
	0x04, 0x19, 0x75, 0x01, 0x4d, 0x6c, 0xd7, 0xb5, 0xdd, 0x91, 0x21, 0xda, 0x8a, 0x26, 0x4f, 0xb3,
	0x92, 0x8a, 0x3a, 0xd5, 0x4a, 0x15, 0x12, 0xf6, 0xa8, 0x6f, 0xbb, 0xa3, 0x2b, 0xd3, 0x09, 0xa7,
	0xc3, 0x14, 0x04, 0x5b, 0x8c, 0xa8, 0x59, 0xe8, 0x0c, 0x80, 0xaf, 0xde, 0x32, 0x4c, 0x2a, 0x67,
	0x58, 0xa5, 0xa2, 0xca, 0xe5, 0x53, 0xa7, 0xf2, 0xa9, 0xfd, 0xa9, 0xbe, 0x7a, 0x56, 0xa0, 0x1b,
	0x14, 0x9d, 0x43, 0xd6, 0x21, 0xc3, 0x8f, 0x9c, 0x99, 0x65, 0xcc, 0xf2, 0x52, 0x0f, 0x33, 0xe6,
	0x74, 0x9d, 0x9c, 0xd2, 0xa0, 0x91, 0x16, 0xd8, 0xb5, 0x38, 0x1b, 0x36, 0x64, 0xa7, 0x19, 0xa3,
	0x41, 0xeb, 0x7b, 0x5f, 0xbe, 0xc9, 0x3b, 0x14, 0x9b, 0xe3, 0x93, 0xf9, 0x1e, 0x83, 0x13, 0xcf,
	0x27, 0x96, 0xf2, 0x23, 0x06, 0x5b, 0x8f, 0x24, 0x5c, 0x32, 0xcd, 0x29, 0x24, 0x87, 0xc4, 0x21,
	0x3e, 0xb3, 0x4c, 0xbe, 0x56, 0x5a, 0x6d, 0x81, 0x08, 0xa5, 0x73, 0xf0, 0x0a, 0x47, 0xbd, 0x86,
	0xbf, 0x29, 0xa1, 0xa6, 0x63, 0x78, 0xc4, 0x76, 0x69, 0xe4, 0xaa, 0x68, 0x92, 0x83, 0xa5, 0x49,
	0x34, 0x97, 0xbe, 0x3c, 0x15, 0x53, 0xe4, 0x18, 0xa3, 0xcb, 0x08, 0xe8, 0x1c, 0x78, 0x68, 0x44,
	0xc6, 0xe5, 0x3e, 0x7a, 0x8a, 0x0f, 0x8c, 0x30, 0x88, 0xf0, 0xa8, 0x0d, 0x79, 0x4a, 0x3c, 0x43,
	0x4c, 0x40, 0xfc, 0xa9, 0xc1, 0x8e, 0xd7, 0x19, 0xac, 0xe1, 0xfb, 0xe6, 0xbd, 0x28, 0xb6, 0x45,
	0x89, 0xd7, 0x9d, 0xb1, 0x95, 0x9f, 0xd2, 0xc3, 0xab, 0xf7, 0x00, 0x88, 0x64, 0x48, 0xf3, 0x37,
	0x84, 0xaf, 0x32, 0xa3, 0x4f, 0x43, 0x54, 0x83, 0xe4, 0x5d, 0x64, 0x32, 0x39, 0xc6, 0xae, 0xd4,
	0xc1, 0xba, 0x4f, 0xeb, 0x1c, 0x8a, 0x14, 0xd8, 0xba, 0x35, 0x03, 0x83, 0x38, 0x96, 0xc1, 0xb9,
	0x71, 0x56, 0x33, 0x77, 0x6b, 0x06, 0x1d, 0xc7, 0x62, 0x9e, 0x45, 0x67, 0x90, 0x9d, 0xe7, 0x13,
	0x1b, 0xd4, 0xce, 0x10, 0x41, 0x55, 0x3e, 0x49, 0x00, 0xf3, 0xc4, 0xe6, 0xcf, 0xc6, 0x3f, 0x90,
	0x12, 0x42, 0xc6, 0xd9, 0x85, 0x16, 0x11, 0xaa, 0x43, 0xca, 0xc7, 0x41, 0xe8, 0x50, 0x21, 0xb0,
	0xb2, 0xb6, 0x0f, 0x86, 0xd4, 0x05, 0x43, 0xf9, 0x2c, 0x41, 0x61, 0x31, 0x89, 0xea, 0x90, 0xa0,
	0xf7, 0x1e, 0x66, 0x3d, 0xe5, 0x6b, 0xff, 0x3d, 0x5d, 0xae, 0x7f, 0xef, 0x61, 0x9d, 0x71, 0x50,
	0x1d, 0x80, 0xb7, 0x65, 0x4c, 0x88, 0xcb, 0x06, 0xc8, 0xd5, 0xf6, 0x97, 0xee, 0x2c, 0x73, 0x0c,
	0xdb, 0x86, 0x9e, 0xe5, 0xf0, 0x6b, 0xe2, 0x2a, 0xbf, 0x24, 0xd8, 0x5f, 0xf3, 0xd2, 0xac, 0x51,
	0xf9, 0x7c, 0xae, 0x72, 0xd4, 0xf2, 0xf1, 0x86, 0x2f, 0xd8, 0x73, 0x04, 0x6f, 0x3e, 0x16, 0xfc,
	0x59, 0x9f, 0x99, 0x69, 0xff, 0xff, 0x57, 0x09, 0xb6, 0xff, 0xb4, 0x3d, 0xa4, 0x40, 0xa9, 0xab,
	0xb7, 0x9a, 0xda, 0x45, 0x5f, 0xeb, 0xb4, 0x0d, 0xbd, 0xd5, 0x1b, 0x5c, 0xf6, 0x8d, 0xfe, 0xbb,
	0x6e, 0xcb, 0xd0, 0xda, 0x57, 0x8d, 0x4b, 0xad, 0x59, 0xf8, 0x0b, 0xfd, 0x0b, 0x87, 0x2b, 0x30,
	0x7a, 0xeb, 0xed, 0xa0, 0xdd, 0x2c, 0x48, 0xa8, 0x04, 0xc5, 0x15, 0x90, 0x6b, 0xad, 0x5d, 0x88,
	0xa1, 0x23, 0xd8, 0x5f, 0x91, 0xbf, 0xec, 0xf4, 0x5a, 0x85, 0xf8, 0x1b, 0xf4, 0x7e, 0xe9, 0xff,
	0xf7, 0x26, 0xc5, 0x74, 0x7b, 0xf1, 0x3b, 0x00, 0x00, 0xff, 0xff, 0x72, 0xe1, 0x8c, 0x19, 0xb9,
	0x07, 0x00, 0x00,
}
