// Code generated by protoc-gen-go. DO NOT EDIT.
// source: raid/update.proto

package raid

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "code.justin.tv/eventbus/schema/pkg/eventbus/owner"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Status describes a raid's place in its lifecycle.
type Status int32

const (
	Status_STATUS_INVALID Status = 0
	// When a raid is started, viewers that have not opted out will be redirected to
	// the target's channel page. A raid can be started explicitly by its broadcaster,
	// or automatically when enough time passes.
	Status_STATUS_STARTED Status = 1
)

var Status_name = map[int32]string{
	0: "STATUS_INVALID",
	1: "STATUS_STARTED",
}
var Status_value = map[string]int32{
	"STATUS_INVALID": 0,
	"STATUS_STARTED": 1,
}

func (x Status) String() string {
	return proto.EnumName(Status_name, int32(x))
}
func (Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_update_512ff77021271cdc, []int{0}
}

// RaidUpdate triggers when a raid has been started.
type RaidUpdate struct {
	// The Raid's ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The user ID of the channel that the raid is originating on.
	FromBroadcasterUserId string `protobuf:"bytes,2,opt,name=from_broadcaster_user_id,json=fromBroadcasterUserId,proto3" json:"from_broadcaster_user_id,omitempty"`
	// The user ID of the channel that the raid is targeting.
	ToBroadcasterUserId string `protobuf:"bytes,3,opt,name=to_broadcaster_user_id,json=toBroadcasterUserId,proto3" json:"to_broadcaster_user_id,omitempty"`
	// The current status for the raid.
	Status Status `protobuf:"varint,4,opt,name=status,proto3,enum=raid.Status" json:"status,omitempty"`
	// The number of users that are part of the raid.
	Viewers int32 `protobuf:"varint,5,opt,name=viewers,proto3" json:"viewers,omitempty"`
	// The date/time the raid was updated.
	UpdatedAt *timestamp.Timestamp `protobuf:"bytes,6,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Whether alerts (such as chat notices) were sent to the target channel.
	// Alerts may be dropped to protect target channels from spam or harassment.
	AlertsSent           bool     `protobuf:"varint,7,opt,name=alerts_sent,json=alertsSent,proto3" json:"alerts_sent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RaidUpdate) Reset()         { *m = RaidUpdate{} }
func (m *RaidUpdate) String() string { return proto.CompactTextString(m) }
func (*RaidUpdate) ProtoMessage()    {}
func (*RaidUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_update_512ff77021271cdc, []int{0}
}
func (m *RaidUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RaidUpdate.Unmarshal(m, b)
}
func (m *RaidUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RaidUpdate.Marshal(b, m, deterministic)
}
func (dst *RaidUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RaidUpdate.Merge(dst, src)
}
func (m *RaidUpdate) XXX_Size() int {
	return xxx_messageInfo_RaidUpdate.Size(m)
}
func (m *RaidUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_RaidUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_RaidUpdate proto.InternalMessageInfo

func (m *RaidUpdate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *RaidUpdate) GetFromBroadcasterUserId() string {
	if m != nil {
		return m.FromBroadcasterUserId
	}
	return ""
}

func (m *RaidUpdate) GetToBroadcasterUserId() string {
	if m != nil {
		return m.ToBroadcasterUserId
	}
	return ""
}

func (m *RaidUpdate) GetStatus() Status {
	if m != nil {
		return m.Status
	}
	return Status_STATUS_INVALID
}

func (m *RaidUpdate) GetViewers() int32 {
	if m != nil {
		return m.Viewers
	}
	return 0
}

func (m *RaidUpdate) GetUpdatedAt() *timestamp.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

func (m *RaidUpdate) GetAlertsSent() bool {
	if m != nil {
		return m.AlertsSent
	}
	return false
}

func init() {
	proto.RegisterType((*RaidUpdate)(nil), "raid.RaidUpdate")
	proto.RegisterEnum("raid.Status", Status_name, Status_value)
}

func init() { proto.RegisterFile("raid/update.proto", fileDescriptor_update_512ff77021271cdc) }

var fileDescriptor_update_512ff77021271cdc = []byte{
	// 338 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x91, 0xcd, 0x4e, 0xc2, 0x40,
	0x10, 0xc7, 0x6d, 0x85, 0x22, 0x8b, 0x21, 0xb8, 0xa2, 0xd9, 0x70, 0xa1, 0x31, 0x1e, 0x1a, 0x13,
	0x5a, 0x03, 0x07, 0xa3, 0xb7, 0x12, 0x3c, 0x90, 0x18, 0x0f, 0x6d, 0xf1, 0xe0, 0xa5, 0xd9, 0xba,
	0x03, 0x69, 0x42, 0xbb, 0xcd, 0xee, 0x14, 0x7c, 0x16, 0xdf, 0xc3, 0x9b, 0x0f, 0x67, 0x68, 0x21,
	0x9a, 0xe8, 0x71, 0xfe, 0x1f, 0x9b, 0xd9, 0xdf, 0x90, 0x33, 0xc5, 0x53, 0xe1, 0x95, 0x85, 0xe0,
	0x08, 0x6e, 0xa1, 0x24, 0x4a, 0xda, 0xd8, 0x49, 0x83, 0x3e, 0x6c, 0x20, 0xc7, 0xa4, 0xd4, 0x9e,
	0xdc, 0xe6, 0xa0, 0x6a, 0x6f, 0x30, 0x5c, 0x49, 0xb9, 0x5a, 0x83, 0x57, 0x4d, 0x49, 0xb9, 0xf4,
	0x30, 0xcd, 0x40, 0x23, 0xcf, 0x8a, 0x3a, 0x70, 0xf5, 0x65, 0x12, 0x12, 0xf0, 0x54, 0x2c, 0xaa,
	0x17, 0x69, 0x97, 0x98, 0xa9, 0x60, 0x86, 0x6d, 0x38, 0xed, 0xc0, 0x4c, 0x05, 0xbd, 0x23, 0x6c,
	0xa9, 0x64, 0x16, 0x27, 0x4a, 0x72, 0xf1, 0xc6, 0x35, 0x82, 0x8a, 0x4b, 0x0d, 0x2a, 0x4e, 0x05,
	0x33, 0xab, 0xd4, 0xc5, 0xce, 0x9f, 0xfe, 0xd8, 0x0b, 0x0d, 0x6a, 0x2e, 0xe8, 0x84, 0x5c, 0xa2,
	0xfc, 0xb7, 0x76, 0x5c, 0xd5, 0xce, 0x51, 0xfe, 0x2d, 0x5d, 0x13, 0x4b, 0x23, 0xc7, 0x52, 0xb3,
	0x86, 0x6d, 0x38, 0xdd, 0xf1, 0xa9, 0xbb, 0xfb, 0x9a, 0x1b, 0x56, 0x5a, 0xb0, 0xf7, 0x28, 0x23,
	0xad, 0x4d, 0x0a, 0x5b, 0x50, 0x9a, 0x35, 0x6d, 0xc3, 0x69, 0x06, 0x87, 0x91, 0xde, 0x13, 0x52,
	0x93, 0x11, 0x31, 0x47, 0x66, 0xd9, 0x86, 0xd3, 0x19, 0x0f, 0xdc, 0x1a, 0x81, 0x7b, 0x40, 0xe0,
	0x46, 0x07, 0x04, 0x41, 0x7b, 0x9f, 0xf6, 0x91, 0x0e, 0x49, 0x87, 0xaf, 0x41, 0xa1, 0x8e, 0x35,
	0xe4, 0xc8, 0x5a, 0xb6, 0xe1, 0x9c, 0x04, 0xa4, 0x96, 0x42, 0xc8, 0xf1, 0xa1, 0xff, 0xf1, 0xc9,
	0x7a, 0x08, 0x3c, 0x1b, 0x6d, 0xde, 0x47, 0x85, 0x92, 0x62, 0x04, 0xf9, 0xea, 0xe6, 0x96, 0x58,
	0xf5, 0x76, 0x94, 0x92, 0x6e, 0x18, 0xf9, 0xd1, 0x22, 0x8c, 0xe7, 0xcf, 0x2f, 0xfe, 0xd3, 0x7c,
	0xd6, 0x3b, 0xfa, 0xa5, 0x85, 0x91, 0x1f, 0x44, 0x8f, 0xb3, 0x9e, 0x31, 0xb5, 0x5e, 0xab, 0x7b,
	0x25, 0x56, 0xb5, 0xcf, 0xe4, 0x3b, 0x00, 0x00, 0xff, 0xff, 0x16, 0x2a, 0xf8, 0xf4, 0xd1, 0x01,
	0x00, 0x00,
}
