// Code generated by protoc-gen-go. DO NOT EDIT.
// source: user_recover/create.proto

package user_recover

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "code.justin.tv/eventbus/schema/pkg/eventbus/owner"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// SourceType is the source type of the account recovery.
type SourceType int32

const (
	// default to invalid
	SourceType_SOURCE_TYPE_INVALID SourceType = 0
	// if source type is unknown
	SourceType_SOURCE_TYPE_OTHER SourceType = 1
	// if request came from a SIRT mass account run
	SourceType_SOURCE_TYPE_BULK SourceType = 2
	// if request came from admin panel
	SourceType_SOURCE_TYPE_MANUAL SourceType = 3
)

var SourceType_name = map[int32]string{
	0: "SOURCE_TYPE_INVALID",
	1: "SOURCE_TYPE_OTHER",
	2: "SOURCE_TYPE_BULK",
	3: "SOURCE_TYPE_MANUAL",
}
var SourceType_value = map[string]int32{
	"SOURCE_TYPE_INVALID": 0,
	"SOURCE_TYPE_OTHER":   1,
	"SOURCE_TYPE_BULK":    2,
	"SOURCE_TYPE_MANUAL":  3,
}

func (x SourceType) String() string {
	return proto.EnumName(SourceType_name, int32(x))
}
func (SourceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_create_7a6d888e6f9a0454, []int{0}
}

// UserRecoverCreate triggers when a account goes though the recovery process either in bulk during a SIRT or though admin panel.
type UserRecoverCreate struct {
	// user id that was recovered
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// ldap of the staff who initiated the account-recovery , required
	LdapRunner string `protobuf:"bytes,2,opt,name=ldap_runner,json=ldapRunner,proto3" json:"ldap_runner,omitempty"`
	// What is the type/source of recovery being preformed, required
	// “manual”, “bulk”, “other”
	SourceType SourceType `protobuf:"varint,3,opt,name=source_type,json=sourceType,proto3,enum=user_recover.SourceType" json:"source_type,omitempty"`
	// detail of the source, shows in admin panel audits, for example "SIRT-257" or "customer requested recovery"
	SourceDetail string `protobuf:"bytes,4,opt,name=source_detail,json=sourceDetail,proto3" json:"source_detail,omitempty"`
	// optional, when did the account become compromised
	CompromisedAt        *timestamp.Timestamp `protobuf:"bytes,5,opt,name=compromised_at,json=compromisedAt,proto3" json:"compromised_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UserRecoverCreate) Reset()         { *m = UserRecoverCreate{} }
func (m *UserRecoverCreate) String() string { return proto.CompactTextString(m) }
func (*UserRecoverCreate) ProtoMessage()    {}
func (*UserRecoverCreate) Descriptor() ([]byte, []int) {
	return fileDescriptor_create_7a6d888e6f9a0454, []int{0}
}
func (m *UserRecoverCreate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UserRecoverCreate.Unmarshal(m, b)
}
func (m *UserRecoverCreate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UserRecoverCreate.Marshal(b, m, deterministic)
}
func (dst *UserRecoverCreate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UserRecoverCreate.Merge(dst, src)
}
func (m *UserRecoverCreate) XXX_Size() int {
	return xxx_messageInfo_UserRecoverCreate.Size(m)
}
func (m *UserRecoverCreate) XXX_DiscardUnknown() {
	xxx_messageInfo_UserRecoverCreate.DiscardUnknown(m)
}

var xxx_messageInfo_UserRecoverCreate proto.InternalMessageInfo

func (m *UserRecoverCreate) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *UserRecoverCreate) GetLdapRunner() string {
	if m != nil {
		return m.LdapRunner
	}
	return ""
}

func (m *UserRecoverCreate) GetSourceType() SourceType {
	if m != nil {
		return m.SourceType
	}
	return SourceType_SOURCE_TYPE_INVALID
}

func (m *UserRecoverCreate) GetSourceDetail() string {
	if m != nil {
		return m.SourceDetail
	}
	return ""
}

func (m *UserRecoverCreate) GetCompromisedAt() *timestamp.Timestamp {
	if m != nil {
		return m.CompromisedAt
	}
	return nil
}

func init() {
	proto.RegisterType((*UserRecoverCreate)(nil), "user_recover.UserRecoverCreate")
	proto.RegisterEnum("user_recover.SourceType", SourceType_name, SourceType_value)
}

func init() { proto.RegisterFile("user_recover/create.proto", fileDescriptor_create_7a6d888e6f9a0454) }

var fileDescriptor_create_7a6d888e6f9a0454 = []byte{
	// 346 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x54, 0x91, 0xcd, 0x4e, 0xc2, 0x40,
	0x14, 0x85, 0x2d, 0x28, 0xc6, 0xcb, 0x4f, 0xca, 0x88, 0x52, 0xd9, 0x40, 0x74, 0x43, 0x4c, 0x6c,
	0x13, 0x5c, 0xe9, 0xae, 0xfc, 0x24, 0x12, 0x11, 0x4c, 0x69, 0x4d, 0x74, 0xd3, 0x94, 0xf6, 0x4a,
	0x6a, 0x68, 0xa7, 0x99, 0x99, 0x62, 0x58, 0xfb, 0x16, 0xbe, 0x87, 0xef, 0x67, 0x98, 0x8a, 0xd6,
	0x5d, 0xef, 0x77, 0xcf, 0x3d, 0x3d, 0x27, 0x03, 0x67, 0x29, 0x47, 0xe6, 0x32, 0xf4, 0xe9, 0x1a,
	0x99, 0xe1, 0x33, 0xf4, 0x04, 0xea, 0x09, 0xa3, 0x82, 0x92, 0x4a, 0x7e, 0xd5, 0x6a, 0xe0, 0x1a,
	0x63, 0xb1, 0x48, 0xb9, 0x41, 0xdf, 0x63, 0x64, 0x99, 0xa6, 0xd5, 0x5e, 0x52, 0xba, 0x5c, 0xa1,
	0x21, 0xa7, 0x45, 0xfa, 0x6a, 0x88, 0x30, 0x42, 0x2e, 0xbc, 0x28, 0xc9, 0x04, 0xe7, 0x1f, 0x05,
	0xa8, 0x3b, 0x1c, 0x99, 0x95, 0xd9, 0x0c, 0xe4, 0x0f, 0x48, 0x13, 0x0e, 0xa5, 0x79, 0x18, 0x68,
	0x4a, 0x47, 0xe9, 0x1e, 0x59, 0xa5, 0xed, 0x38, 0x0e, 0x48, 0x1b, 0xca, 0xab, 0xc0, 0x4b, 0x5c,
	0x96, 0xc6, 0x31, 0x32, 0xad, 0x20, 0x97, 0xb0, 0x45, 0x96, 0x24, 0xe4, 0x06, 0xca, 0x9c, 0xa6,
	0xcc, 0x47, 0x57, 0x6c, 0x12, 0xd4, 0x8a, 0x1d, 0xa5, 0x5b, 0xeb, 0x69, 0x7a, 0x3e, 0xaa, 0x3e,
	0x97, 0x02, 0x7b, 0x93, 0xa0, 0x05, 0xfc, 0xf7, 0x9b, 0x5c, 0x40, 0xf5, 0xe7, 0x34, 0x40, 0xe1,
	0x85, 0x2b, 0x6d, 0x5f, 0xba, 0x57, 0x32, 0x38, 0x94, 0x8c, 0x98, 0x50, 0xf3, 0x69, 0x94, 0x30,
	0x1a, 0x85, 0x1c, 0x03, 0xd7, 0x13, 0xda, 0x41, 0x47, 0xe9, 0x96, 0x7b, 0x2d, 0x3d, 0x6b, 0xaa,
	0xef, 0x9a, 0xea, 0xf6, 0xae, 0xa9, 0x55, 0xcd, 0x5d, 0x98, 0xe2, 0xb6, 0xfe, 0xf9, 0xa5, 0x55,
	0x05, 0x7a, 0xd1, 0x55, 0x18, 0x60, 0x2c, 0x42, 0xb1, 0xb9, 0x7c, 0x03, 0xf8, 0x0b, 0x45, 0x9a,
	0x70, 0x3c, 0x9f, 0x39, 0xd6, 0x60, 0xe4, 0xda, 0xcf, 0x8f, 0x23, 0x77, 0x3c, 0x7d, 0x32, 0x27,
	0xe3, 0xa1, 0xba, 0x47, 0x4e, 0xa0, 0x9e, 0x5f, 0xcc, 0xec, 0xbb, 0x91, 0xa5, 0x2a, 0xa4, 0x01,
	0x6a, 0x1e, 0xf7, 0x9d, 0xc9, 0xbd, 0x5a, 0x20, 0xa7, 0x40, 0xf2, 0xf4, 0xc1, 0x9c, 0x3a, 0xe6,
	0x44, 0x2d, 0xf6, 0x6b, 0x2f, 0xff, 0x1e, 0x6e, 0x51, 0x92, 0x89, 0xaf, 0xbf, 0x03, 0x00, 0x00,
	0xff, 0xff, 0xc1, 0xef, 0xce, 0x38, 0xea, 0x01, 0x00, 0x00,
}
