package sqspoller

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/sqs"
)

type Config struct {
	Client   SQSAPI              // required: SQS client or compatible interface
	QueueURL string              // required: the URL to the SQS queue
	Deliver  chan<- *sqs.Message // required: a channel where messages are delivered.

	HookCallback      HookCallback // A callback for secondary info/error runtime hooks.
	NumPollers        int          // Number of poller goroutines to run; default 2
	VisibilitySeconds int64        // Visibility timeout to SQS; default 30sec
}

func (c *Config) defaults() {
	if c.HookCallback == nil {
		c.HookCallback = func(HookEvent) {}
	}
	if c.NumPollers == 0 {
		c.NumPollers = 2
	}
	if c.VisibilitySeconds == 0 {
		c.VisibilitySeconds = 30
	}
}

// SQSAPI is a strict subset of sqsiface.SQSAPI, exists just to make mocking easier
type SQSAPI interface {
	ReceiveMessageWithContext(aws.Context, *sqs.ReceiveMessageInput, ...request.Option) (*sqs.ReceiveMessageOutput, error)
	DeleteMessageBatchWithContext(aws.Context, *sqs.DeleteMessageBatchInput, ...request.Option) (*sqs.DeleteMessageBatchOutput, error)
}

type HookCallback func(HookEvent)
