/*
package sqspoller is a high-throughput polling client for SQS.

The client is a concurrent polling implementation, in where a number of goroutines simultaneously
long-poll SQS, forwarding the messages onto a user-provided channel. The pollers will use this
channel for back-pressure, reducing the chance of "over-committing" on a busy worker.

See DESIGN.md for more on the design/internals of the poller and future of this library.

Message Acks

SQS requires a message to be deleted off the queue in order for it to not keep showing up
on future receives, and this poller's implementation also provides concurrent batch message acking.
It is up to the user of the library to call `poller.Ack` for each message after it is done processing.
This message will then be queued to be ack'd as part of a batch.

Staged Shutdown

As the user manages the in-flight channel, we provide shutdown in stages. It is up to the user
of the library to decide when to perform each stage of the shutdown (stopping polling and stopping
acks)in the implementation of their own graceful shutdown logic.

Lifecycle Events

Since the poller runs many goroutines, there are possibilities of temporary failures that happen,
and those will normally be 'swallowed' by the client. If you want to log or see these events, use
the HookCallback feature to handle both informational and error scenarios.

*/
package sqspoller
