#!bin/python

from termcolor import colored
import boto3
import json
import decimal
import requests
import time

session = boto3.Session(region_name='us-west-2')
elbClient = session.client("elb")

elb_list = elbClient.describe_load_balancers()

elbs = {}
elbNameMaxLength = 0

# print(json.dumps(elb_list, indent=4, default=str))

for elb in elb_list["LoadBalancerDescriptions"]:
    name = elb['LoadBalancerName']
    elbs[name] = { "HTTPCode_ELB_5XX_Alert": colored(u'\u2718', 'red'), "SpilloverCount_Alert": colored(u'\u2718', 'red'), "HealthyHostCount_Alert": colored(u'\u2718', 'red') }

    if len(name) > elbNameMaxLength:
        elbNameMaxLength = len(name)

cloudwatch = session.client("cloudwatch")
response = cloudwatch.describe_alarms()

while True:
    for alarm in response["MetricAlarms"]:
        if alarm["Namespace"] != "AWS/ELB":
            continue
    
        elbName = None
        type = alarm["MetricName"]
        action = alarm["AlarmActions"]
    
        for dimension in alarm["Dimensions"]:
            if dimension["Name"] == "LoadBalancerName":
                elbName = dimension["Value"]
            else:
                print("unknown dimension name %s.", dimension["Name"])
    
        if elbName not in elbs:
            continue

        if type == "SpilloverCount":
            elbs[elbName]["SpilloverCount_Alert"] = colored(u'\u2714', 'green')
        elif type == "HTTPCode_ELB_5XX":
            elbs[elbName]["HTTPCode_ELB_5XX_Alert"] = colored(u'\u2714', 'green')
        elif type == "HealthyHostCount":
            elbs[elbName]["HealthyHostCount_Alert"] = colored(u'\u2714', 'green')

    if "NextToken" not in response:
        break

    response = cloudwatch.describe_alarms(NextToken = response["NextToken"])

# print(json.dumps(elbs, indent=4, sort_keys=True, default=str))

headerFormat = "%" + str(elbNameMaxLength) + "s\t%24s\t%24s\t%24s"
format = "%" + str(elbNameMaxLength) + "s\t\t%24s\t\t%24s\t\t%24s"

print(headerFormat % ("Table Name", "SpilloverCount_Alert", "HTTPCode_ELB_5XX_Alert", "HealthyHostCount_Alert"))

for name, data in elbs.items():
    print(format % (name, data["SpilloverCount_Alert"], data["HTTPCode_ELB_5XX_Alert"], data["HealthyHostCount_Alert"]))
