#!/bin/bash
set -uo pipefail

# This is a super simple build/push docker flow

BIN=$(dirname $BASH_SOURCE)

for f in `ls ${BIN}/modules/*.sh`; do
  source ${f}
done

# these come from the environment
#
# ORG - your organization at twitch, for example: gds
# PROJ - name of the project you're building. There are assumptions here, for exmaple
#        it is assumed you are using a Dockerfile-service for production builds, etc.
ORG=${ORG}
PROJ=${PROJ}

# This isn't a typical "service", so override the service file.
export DOCKER_SERVICE="Dockerfile"

docker::build ${PROJ} ${ORG} "latest"
docker::publish ${PROJ} ${ORG} ${DOCKER_TAG}
