#!/bin/bash -x
set -o pipefail

BIN=$(dirname $BASH_SOURCE)
export PWD=$(pwd)

# Later modules will `set -u`, so this variable needs to be set now
DEFAULT_SERVICE_TEMPLATE=svc/service.yaml
if [ -z ${SERVICE_TEMPLATE} ]; then
	SERVICE_TEMPLATE=${DEFAULT_SERVICE_TEMPLATE}
fi

for f in `ls ${BIN}/modules/*.sh`; do
  source ${f}
done

# these come from the environment
#
# ORG - your organization at twitch, for example: gds
# PROJ - name of the project you're building a deb of
# DOCKER_SHA - the canonical sha for the docker image we'll be building a deb for
# PACKAGE_VERSION - the version of the application we're building a deb for
# GIT_COMMIT - the git commit that the docker image was built for, provided to spinnaker via spinnaker.properties
ORG=${ORG}
PROJ=${PROJ}
DOCKER_SHA=${DOCKER_SHA}
PACKAGE_VERSION=${PACKAGE_VERSION}
GIT_COMMIT=${GIT_COMMIT}

utils::prepdirs ${PWD}
service::definition ${PROJ} ${ORG} ${DOCKER_SHA} ${BUILD_DIR} ${SERVICE_TEMPLATE}
service::controlfile ${PROJ} ${ORG} ${PACKAGE_VERSION} ${DOCKER_SHA} ${BUILD_DIR} ${GIT_COMMIT}
service::upstart ${BUILD_DIR}
service::postinst ${BUILD_DIR}
aptly::build ${PROJ} ${ORG} ${PACKAGE_VERSION} ${DOCKER_SHA} ${BUILD_DIR} ${OUTPUT_DIR}
aptly::maybe_publish ${PROJ} ${ORG} ${PACKAGE_VERSION} ${DOCKER_SHA} ${APTLY_ARTIFACT}

# in the case of manually triggering in spinnaker we don't want to exit 1 if maybe_publish
# returns 1, so echo something to logs and continue
if [ $? -eq 1 ]; then
  echo "${PROJ}/${ORG} @ ${PACKAGE_VERSION} ${DOCKER_SHA} already exists, continuing..."
fi

exit 0
