#!/bin/bash

##
## - This script iterates over the list of ACM certificates in the AWS account
##   determined by your AWS_PROFILE env var and prints out the date of expiration 
##   for each domain.
##
set -euo pipefail

BIN=$(dirname $BASH_SOURCE)
export PWD=$(pwd)

for i in `aws acm list-certificates | jq '.CertificateSummaryList[].CertificateArn' | sed -e 's/"//g'`; do 
	aws acm describe-certificate --certificate-arn $i | \
		jq 'select (.Certificate.NotAfter != null) | .Certificate | [(.NotAfter | gmtime | strftime("%Y-%m-%d")), .DomainName] | join(": ")'
done
