#!/bin/bash -x
set -uo pipefail

BIN=$(dirname $BASH_SOURCE)
export PWD=$(pwd)

for f in `ls ${BIN}/modules/*.sh`; do
  source ${f}
done

# these come from the environment
#
# ORG - your organization at twitch, for example: gds
# PROJ - name of the project you're building. There are assumptions here, for exmaple
#        it is assumed you are using a Dockerfile-service for production builds, etc.
ORG=${ORG}
PROJ=${PROJ}

utils::prepdirs ${PWD}
docker::build ${PROJ} ${ORG}
docker::publish ${PROJ} ${ORG} ${DOCKER_TAG}

aptly::should_publish ${PROJ} ${ORG} ${DOCKER_VERSION} ${DOCKER_SHA}
if [ $? -eq 0 ]; then
  spinnaker::properties ${DOCKER_VERSION} ${DOCKER_SHA} ${OUTPUT_DIR}
fi
