# Recipe for auto-reload of Go from inside a Docker container

## In your Dockerfile

```
RUN go get github.com/handwritingio/autoreload
RUN apt-get install -y inotify-tools
ENTRYPOINT watching_entrypoint.sh
```

## In your docker-compose file

* Be sure to mount the host volume that contains your Go project.
* Be sure the shell scripts `watch_with_inotify.sh` is accessible in your container
* Copy the contents of `watching_entrypoint.sh` into your development entrypoint, and
modify the watched directory as appropriate for your project.

## How it works

* apt package `inotify-tools` contains a CLI tool called `inotifywait`
  which watches files recursively and exits when one changes.
* The `github.com/handwritingio/autoreload` is a package that will re-compile
  and run a Go project upon receipt of a signal on port 12345.
* The `watching_entrypoint.sh` script starts up a monitor called
  `watch_with_inotify.sh` as a background task which has a while forever
  loop that starts up `inotifywait` and when it exits uses `nc` to send
  a packet on port 12345 to the `autoreload` program thus causing
  the Go program to restart.

