#!/bin/bash

set -e

RESET_PORT=12345
WATCH_FOLDER=$1

while true; do
    # WAIT for changes
    echo "Watching ${WATCH_FOLDER}"
    inotifywait $WATCH_FOLDER --recursive --exclude build --event modify --event create --event move

    # Tickle autoreload
    echo 'Reloading server'
    echo 'reset' | nc -w 1 localhost $RESET_PORT
done
