#!/bin/bash
set -uo pipefail

###
### -- usage: local_docker_build.sh portal/boxart
###
### -- this script builds the docker just like build_docker.sh does, but does not
###    require specification of the ORG and PROJ as environment variables on the
###    command line and does not attempt to upload the result to a docker registry.
###

BIN=$(dirname $BASH_SOURCE)
export PWD=$(pwd)

for f in `ls ${BIN}/modules/*.sh`; do
  source ${f}
done

# these come from the environment
#
# ORG - your organization at twitch, for example: gds
# PROJ - name of the project you're building. There are assumptions here, for exmaple
#        it is assumed you are using a Dockerfile-service for production builds, etc.
ORG=${USER}
PROJ=${1}

utils::prepdirs ${PWD}
docker::build ${PROJ} ${ORG}
