#!/bin/bash
set -uo pipefail

# Provides spinnaker related functions

# properties - outputs a java properties style file named spinnaker.properties containing
#              properties necessary for our spinnaker integration. Args are positional.
#              Arg 1: the version of the project your building, this is written out as PACKAGE_VERSION
#              Arg 2: the canonical sha for the docker image we've published, this is written out as DOCKER_SHA
spinnaker::properties() {
  local package_version=${1}
  local docker_sha=${2}
  local output_dir=${3}

  cat > ${output_dir}/spinnaker.properties <<EOF
DOCKER_SHA=${docker_sha}
PACKAGE_VERSION=${package_version}
EOF
}
