#!/bin/bash -x

##
## - This short script will upgrade your terraform from 0.9 to 0.10, grab the
##   latest version of the terraform spinnaker provider, and move it into the
##   directory where terraform can find it.  Terraform no longer obeys
##   ~/.terraformrc which is where we had the location of the provider
##   configured previously, but that is a bug they want to fix.  For now we
##   must copy the provider file around a little bit, no big deal.
##
## - This also cleans up from previous installs of terraform from source, if
##   you still have that on your system.
##

rm -f $GOPATH/bin/terraform*
brew update
brew upgrade terraform
if [ -d $GOPATH/src/code.justin.tv/gds/terraform-provider-spinnaker ]; then
	cd $GOPATH/src/code.justin.tv/gds/terraform-provider-spinnaker
	git pull
fi

go get code.justin.tv/gds/terraform-provider-spinnaker
mkdir -p ~/.terraform.d/plugins
cp $GOPATH/bin/terraform-provider-spinnaker ~/.terraform.d/plugins
