#!/bin/bash
set -uo pipefail

BIN=$(dirname $BASH_SOURCE)
export PWD=$(pwd)

for f in `ls ${BIN}/modules/*.sh`; do
  source ${f}
done

# these come from the environment
#
# DOCKER_SHA - the canonical sha for the docker image we'll be building a deb for
# PACKAGE_VERSION - the version of the application we're building a deb for
DOCKER_SHA=${DOCKER_SHA}
PACKAGE_VERSION=${PACKAGE_VERSION}

utils::prepdirs ${PWD}
spinnaker::properties ${PACKAGE_VERSION} ${DOCKER_SHA} ${OUTPUT_DIR}
