package api

import fultonConfigService "code.justin.tv/extensions/fulton-configuration/client"

// API is a collection of resources necessary for routing to Fulton
type API struct {
	fultonRoutingPercent int64
	alreadyCompared      map[string]bool
	fultonClient         fultonConfigService.Client
}

// NewAPI generates a new API struct
func NewAPI(routingPercent int64, client fultonConfigService.Client) *API {
	return &API{
		fultonRoutingPercent: routingPercent,
		alreadyCompared:      map[string]bool{},
		fultonClient:         client,
	}
}
