# Extensions Configuration Service API
### DeleteConfiguration
#### Description
Deletes an extension configuration for a specific channel id. The client method is unused by Visage / Graphql.
#### Authorization
```
Cartman.CanDeleteConfig | cap: "edit_broadcaster_configuration"
```
#### Calls
```
Route: DELETE /channel/:cid
Client: ConfigService.DeleteChannelConfiguration
```

### GetChannelConfiguration
#### Description
Returns the configuration for an extension of a specific channel. This is used by [Visage](https://git-aws.internal.justin.tv/edge/visage/blob/master/api/v5/devsuccess/extensions/get_extension_configuration_by_channel.go) and [GraphQL](https://git-aws.internal.justin.tv/edge/graphql/blob/9bd8bf7f7e9acd6fd94db2d6d79eeb8526d50194/loaders/extension_configurations.go)
#### Authorization
```
Cartman.CanReadConfig | cap: "read_configuration"
```
#### Calls
```
Route: GET /channel/:cid
Client: ConfigService.GetChannelConfiguration
```

### GetConfiguration
#### Description
Returns the configuration or configurations for an extensionID | segmentType or extensionID | channelID | segmentType. This method is called by [Visage](https://git-aws.internal.justin.tv/edge/visage/blob/master/api/v5/devsuccess/extensions/get_extension_configuration.go)
#### Authorization
```
NO AUTH
```
#### Calls
```
Route: GET /addresses
Client: ConfigService.GetConfiguration
```

### SetChannelConfiguration
#### Description
Set the broadcaster or developer configuration for an extension | channelID pair.
#### Authorization
```
No Auth
```
#### Calls
```
Route: /channel/:cid
Client: ConfigService.SetChannelConfiguration
```

### SetConfiguration
#### Description
Sets the broadcaster, developer, or global configuration for a specific extensionID or extensionID / channelID pair. This is called by [Visage](https://git-aws.internal.justin.tv/edge/visage/blob/master/api/v5/devsuccess/extensions/set_extension_configuration.go)
#### Authorization
```
Cartman.CanEditConfig | caps: "edit_broadcaster_configuration", "edit_developer_configuration"
Cartman.CanReadConfig | caps: "read_configuration"
```
#### Calls
```
Route: PUT /addresses
Client: ConfigService.SetConfiguration
```
