package api

import (
	"context"

	"code.justin.tv/extensions/configuration/services/main/auth"

	"code.justin.tv/extensions/configuration/services/main/data"
	"code.justin.tv/gds/gds/golibs/params"
)

func (a *API) DeleteConfiguration(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	cid := p.Get("cid")

	creds := auth.Load(ctx)
	if barbradyCreds, ok := creds.(*auth.BarbradyCredentials); ok {
		barbradyCreds.RequestCapabilities(
			[]string{auth.CapEditBroadcasterConfig},
			map[string]string{
				auth.ParamChannelID: cid,
			},
		)
	}

	return nil, data.Load(ctx).DeleteByChannel(cid)
}
