package api

import (
	"context"

	"code.justin.tv/extensions/configuration/services/main/auth"
	"code.justin.tv/extensions/configuration/services/main/data"
	"code.justin.tv/extensions/configuration/services/main/protocol"
	"code.justin.tv/gds/gds/golibs/params"
)

func (api *API) DeleteConfigurationV2(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	cid := p.Get("cid")

	var deleteConfigurationV2Body protocol.EditConfigurationV2Input
	if err := p.ParseJSONBody(&deleteConfigurationV2Body); err != nil {
		return nil, protocol.ErrMissingBody
	}

	barbradyParams := map[string]string{auth.ParamChannelID: cid}
	if deleteConfigurationV2Body.ExtJwt != "" {
		barbradyParams[auth.ParamJWT] = deleteConfigurationV2Body.ExtJwt
		if deleteConfigurationV2Body.ClientId == "" {
			return nil, protocol.ErrMissingClientID
		}
		barbradyParams[auth.ParamClientID] = deleteConfigurationV2Body.ClientId
	}

	if deleteConfigurationV2Body.UserID != "" {
		barbradyParams[auth.ParamUserID] = deleteConfigurationV2Body.UserID
	}

	creds := auth.Load(ctx)
	if barbradyCreds, ok := creds.(*auth.BarbradyCredentials); ok {
		barbradyCreds.RequestCapabilities(
			[]string{auth.CapEditBroadcasterConfig},
			barbradyParams,
		)
	}

	return nil, data.Load(ctx).DeleteByChannel(cid)
}
