package api

import (
	"context"
	"strconv"
	"strings"

	"code.justin.tv/extensions/configuration/services/main/data"
	"code.justin.tv/extensions/configuration/services/main/protocol"
	"code.justin.tv/gds/gds/golibs/params"
)

func (a *API) GetChannelConfiguration(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	ext := strings.Split(p.Get("ext_ids"), ",")
	chId := p.Get("cid")
	for i, s := range ext {
		ext[i] = strings.TrimSpace(s)
	}
	common := p.Get("common")
	includeCommon := true
	if common != "" {
		var err error
		includeCommon, err = strconv.ParseBool(common)
		if err != nil {
			return nil, protocol.ErrInvalidCommonParameter
		}
	}

	if a.shouldMigrateTraffic() && a.fultonClient != nil {
		fultonResponse, _ := a.fultonClient.GetChannelConfiguration(ctx, chId, false, ext, nil)
		if !a.alreadyCompared["get_channel_configuration"] {
			configResponse, _ := data.Load(ctx).GetByChannel(chId, includeCommon, ext...)
			a.compareResponseBodies("get_channel_configuration", configResponse, a.convertFultonRecordMapToLocal(fultonResponse))
		}
	}

	return data.Load(ctx).GetByChannel(chId, includeCommon, ext...)
}
