package api

import (
	"context"

	"code.justin.tv/extensions/configuration/services/main/data"
	"code.justin.tv/extensions/configuration/services/main/protocol"
	fultonClient "code.justin.tv/extensions/fulton-configuration/protocol"
	"code.justin.tv/gds/gds/golibs/params"
)

func (a *API) GetConfiguration(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	var addr []protocol.Address
	if err := p.ParseJSONBody(&addr); err != nil {
		return nil, err
	}

	if a.shouldMigrateTraffic() && a.fultonClient != nil {
		var fultonAddr []fultonClient.Address
		for _, address := range addr {
			fultonAddr = append(fultonAddr, fultonClient.Address{
				ExtensionID: address.ExtensionID,
				SegmentType: fultonClient.SegmentType(string(address.SegmentType)),
				ChannelID:   address.ChannelID,
			})
		}
		fultonResponse, _ := a.fultonClient.GetConfiguration(ctx, fultonAddr, nil)

		if !a.alreadyCompared["get_configuration"] {
			configResponse, _ := data.Load(ctx).Get(addr...)
			a.compareResponseBodies("get_configuration", configResponse, a.convertFultonRecordMapToLocal(fultonResponse))
		}
	}
	return data.Load(ctx).Get(addr...)
}
