package api

import (
	"context"

	"code.justin.tv/extensions/configuration/services/main/auth"

	"code.justin.tv/extensions/configuration/services/main/data"
	"code.justin.tv/extensions/configuration/services/main/protocol"
	"code.justin.tv/gds/gds/golibs/params"
)

func (api *API) SetChannelConfiguration(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	var in protocol.SetChannelConfigurationInput
	if err := p.ParseJSONBody(&in); err != nil {
		return nil, err
	}
	creds := auth.Load(ctx)

	ext, err := data.Load(ctx).ForExtension(in.ExtensionID)
	if err != nil {
		return nil, err
	}
	if in.Developer != nil {
		seg, err := protocol.Developer(in.ChannelID)
		if err != nil {
			return nil, err
		}

		if barbradyCreds, ok := creds.(*auth.BarbradyCredentials); ok {
			barbradyCreds.RequestCapabilities(
				[]string{auth.CapEditDeveloperConfig},
				map[string]string{
					auth.ParamExtensionID: in.ExtensionID,
				},
			)
		}
		ext.Set(seg, in.Developer)
	}
	if in.Broadcaster != nil {
		seg, err := protocol.Broadcaster(in.ChannelID)
		if err != nil {
			return nil, err
		}

		if barbradyCreds, ok := creds.(*auth.BarbradyCredentials); ok {
			barbradyCreds.RequestCapabilities(
				[]string{auth.CapEditBroadcasterConfig},
				map[string]string{
					auth.ParamChannelID: in.ChannelID,
				},
			)
		}
		ext.Set(seg, in.Broadcaster)
	}
	return nil, ext.Save()
}
