package api

import (
	"context"

	"code.justin.tv/extensions/configuration/services/main/auth"

	"code.justin.tv/extensions/configuration/services/main/data"
	"code.justin.tv/extensions/configuration/services/main/protocol"
	"code.justin.tv/gds/gds/golibs/params"
)

func (api *API) SetChannelConfigurationV2(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	var in protocol.SetChannelConfigurationInputV2
	if err := p.ParseJSONBody(&in); err != nil {
		return nil, err
	}
	creds := auth.Load(ctx)

	barbradyParams := map[string]string{}
	if in.ExtJwt != "" {
		barbradyParams[auth.ParamJWT] = in.ExtJwt
		if in.ClientId == "" {
			return nil, protocol.ErrMissingClientID
		}
		barbradyParams[auth.ParamClientID] = in.ClientId
	}

	if in.UserID != "" {
		barbradyParams[auth.ParamUserID] = in.UserID
	}

	ext, err := data.Load(ctx).ForExtension(in.ExtensionID)
	if err != nil {
		return nil, err
	}
	if in.Developer != nil {
		seg, err := protocol.Developer(in.ChannelID)
		if err != nil {
			return nil, err
		}

		if barbradyCreds, ok := creds.(*auth.BarbradyCredentials); ok {
			barbradyParams[auth.ParamExtensionID] = in.ExtensionID
			barbradyCreds.RequestCapabilities(
				[]string{auth.CapEditDeveloperConfig},
				barbradyParams,
			)
		}
		ext.Set(seg, in.Developer)
	}
	if in.Broadcaster != nil {
		seg, err := protocol.Broadcaster(in.ChannelID)
		if err != nil {
			return nil, err
		}

		if barbradyCreds, ok := creds.(*auth.BarbradyCredentials); ok {
			barbradyParams[auth.ParamChannelID] = in.ChannelID
			barbradyCreds.RequestCapabilities(
				[]string{auth.CapEditBroadcasterConfig},
				barbradyParams,
			)
		}
		ext.Set(seg, in.Broadcaster)
	}
	return nil, ext.Save()
}
