package api

import (
	"context"

	"code.justin.tv/extensions/configuration/services/main/auth"

	"code.justin.tv/extensions/configuration/services/main/data"
	"code.justin.tv/extensions/configuration/services/main/protocol"
	"code.justin.tv/gds/gds/golibs/params"
)

func (api *API) SetConfiguration(ctx context.Context) (interface{}, error) {
	p := params.New(ctx)
	var in protocol.SetConfigurationInput
	if err := p.ParseJSONBody(&in); err != nil {
		return nil, err
	}
	seg, err := in.Address.Segment()
	if err != nil {
		return nil, err
	}
	ext, err := data.Load(ctx).ForExtension(in.Address.ExtensionID)
	if err != nil {
		return nil, err
	}
	record := in.Record
	if record == nil {
		record = protocol.NewRecord("", nil)
	}

	creds := auth.Load(ctx)
	if barbradyCreds, ok := creds.(*auth.BarbradyCredentials); ok {
		barbradyCreds.RequestCapabilities(
			[]string{auth.CapEditDeveloperConfig, auth.CapEditBroadcasterConfig},
			map[string]string{
				auth.ParamExtensionID: in.Address.ExtensionID,
				auth.ParamChannelID:   seg.ChannelID(),
			},
		)
	}

	return nil, ext.Set(seg, record).Save()
}
