package api

import (
	"math/rand"

	"code.justin.tv/extensions/configuration/services/main/protocol"
	fultonClient "code.justin.tv/extensions/fulton-configuration/protocol"
	"github.com/sirupsen/logrus"
)

func (a *API) shouldMigrateTraffic() bool {
	if int64(rand.Intn(100)) < a.fultonRoutingPercent {
		return true
	}

	return false
}

func (a *API) compareResponseBodies(method string, cfsRespsonse protocol.RecordMap, fultonResponse protocol.RecordMap) {
	if !a.alreadyCompared[method] {
		a.alreadyCompared[method] = true

		for address, record := range cfsRespsonse {
			if fultonRecord, ok := fultonResponse[address]; ok {
				if !protocol.RecordEqual(record, fultonRecord) {
					// Address exists, but record is different. Log
					logrus.WithFields(logrus.Fields{
						"method":                method,
						"cfs_record_content":    *record.Content(),
						"cfs_record_version":    record.Version(),
						"fulton_record_content": *fultonRecord.Content(),
						"fulton_record_version": fultonRecord.Version(),
					}).Warn("Records for Config Service / Fulton Config Service are different")
				}
			} else {
				// Address does not exist, log
				logrus.WithFields(logrus.Fields{
					"method":  method,
					"address": address.String(),
				}).Warn("Missing address in Fulton Response")

				for address, _ := range fultonResponse {
					logrus.WithFields(logrus.Fields{
						"method":  method,
						"address": address.String(),
					}).Warn("Fulton Response Addresses")
				}

				logrus.Warn("All Addresses printed.")
			}
		}

		// By getting here, this means the response bodies are equal
	}
}

func (a *API) convertFultonRecordMapToLocal(response fultonClient.RecordMap) protocol.RecordMap {
	out := make(protocol.RecordMap)

	for address, record := range response {
		out[protocol.Address{
			ExtensionID: address.ExtensionID,
			SegmentType: protocol.SegmentType(address.SegmentType),
			ChannelID:   address.ChannelID,
		}] = protocol.NewRecord(record.Version(), record.Content())
	}

	return out
}
