package api

import (
	"bytes"
	"code.justin.tv/extensions/configuration/services/main/data"
	"code.justin.tv/extensions/configuration/services/main/data/controller"
	"code.justin.tv/extensions/configuration/services/main/data/model"
	"code.justin.tv/extensions/configuration/services/main/data/model/memory"
	"code.justin.tv/extensions/configuration/services/main/protocol"
	"code.justin.tv/gds/gds/golibs/event"
	"code.justin.tv/gds/gds/golibs/params"
	"code.justin.tv/gds/gds/golibs/uuid"
	"context"
	"encoding/json"
	"io"
	"io/ioutil"
	"strings"
)

const (
	fakeUserId   = "FakeUserId"
	fakeJwt      = "FakeJWT"
	fakeClientId = "FakeClientId"
)

func createBody(ctx context.Context, input interface{}) context.Context {
	body := &bytes.Buffer{}
	_ = json.NewEncoder(body).Encode(input)

	return params.SetBody(ctx, ioutil.NopCloser(body))
}

func createManager(store model.Store) data.ConfigurationManager {
	if store == nil {
		store = memory.New(uuid.NewSource())
	}
	return controller.New(store, event.NewCoordinator(true))
}

func createEditConfigBody(bodyType string) (io.ReadCloser, error) {
	var data protocol.EditConfigurationV2Input
	switch bodyType {
	case "fullBody":
		data.ExtJwt = fakeJwt
		data.ClientId = fakeClientId
		data.UserID = fakeUserId
		break
	case "jwtBody":
		data.ExtJwt = fakeJwt
		data.ClientId = fakeClientId
		break
	case "userIdBody":
		data.UserID = fakeUserId
		break
	case "missingClientId":
		data.ExtJwt = fakeJwt
		break
	case "noBody":
	default:
		break
	}

	m, err := json.Marshal(data)
	if err != nil {
		return nil, err
	}
	reader := strings.NewReader(string(m))
	return ioutil.NopCloser(reader), nil
}
