package auth

import (
	"fmt"

	ga "code.justin.tv/common/goauthorization"
	"code.justin.tv/extensions/configuration/services/main/protocol"
)

type cartmanCredentials struct {
	decoder ga.Decoder
	token   *ga.AuthorizationToken
}

var _ Credentials = &cartmanCredentials{}

// NewCartmanCredentials returns Credentials based on the incoming token
func NewCartmanCredentials(decoder ga.Decoder, token *ga.AuthorizationToken) Credentials {
	return &cartmanCredentials{decoder, token}
}

func (c *cartmanCredentials) String() string {
	return fmt.Sprintf("%+v", c.token.Claims)
}

func (c *cartmanCredentials) ClientID() string {
	return c.token.GetClientID()
}

func (c *cartmanCredentials) UserID() *string {
	if sub := c.token.GetSubject(); sub != "" {
		return &sub
	}
	return nil
}

func (c *cartmanCredentials) CanDeleteConfig(chID string) bool {
	return c.checkToken(editBroadcasterClaims(chID))
}

func (c *cartmanCredentials) CanReadConfig(extID string, segment protocol.Segment) bool {
	return true
}

func (c *cartmanCredentials) CanEditConfig(extID string, segment protocol.Segment) bool {
	if segment.Type() == protocol.BroadcasterType {
		if c.checkToken(editBroadcasterClaims(segment.ChannelID())) {
			return true
		}
	}
	return c.checkToken(editDeveloperClaims(extID))
}

func (c *cartmanCredentials) checkToken(claims ga.CapabilityClaims) bool {
	return c.decoder.Validate(c.token, claims) == nil
}

func editBroadcasterClaims(chID string) ga.CapabilityClaims {
	return ga.CapabilityClaims{
		CapEditBroadcasterConfig: ga.CapabilityClaim{ParamChannelID: chID},
	}
}

func editDeveloperClaims(extID string) ga.CapabilityClaims {
	return ga.CapabilityClaims{
		CapEditDeveloperConfig: ga.CapabilityClaim{ParamExtensionID: extID},
	}
}
