package auth

import (
	"code.justin.tv/extensions/configuration/services/main/protocol"
	"fmt"
)

type FakeCredentials struct {
	UserIDValue        string
	BroadcasterChannel string
	OwnedExtensions    []string
}

func NoPermissions() Credentials {
	return &FakeCredentials{}
}

func AllPermissions() Credentials {
	return &FakeCredentials{
		BroadcasterChannel: "*",
		OwnedExtensions:    []string{"*"},
	}
}

func (f *FakeCredentials) UserID() *string {
	if f.UserIDValue == "" {
		return nil
	}
	return &f.UserIDValue
}

func (f *FakeCredentials) CanDeleteConfig(chID string) bool {
	return (f.BroadcasterChannel != "" && f.BroadcasterChannel == chID) || f.BroadcasterChannel == "*"
}

func (f *FakeCredentials) CanReadConfig(extID string, s protocol.Segment) bool {
	return true
}

func (f *FakeCredentials) CanEditConfig(extID string, s protocol.Segment) bool {
	if s.Type() == protocol.BroadcasterType {
		if f.BroadcasterChannel == s.ChannelID() || f.BroadcasterChannel == "*" {
			return true
		}
	}
	for _, id := range f.OwnedExtensions {
		if extID == id || id == "*" {
			return true
		}
	}
	return false
}

func (f *FakeCredentials) ClientID() string {
	return ""
}

func (f *FakeCredentials) String() string {
	return fmt.Sprintf("FakeCredentials(%v,%v,%v)", f.UserIDValue, f.BroadcasterChannel, f.OwnedExtensions)
}
