package auth

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestFakeHandler(t *testing.T) {
	t.Run("should return NoPermissions() if unset", func(t *testing.T) {
		handler := &FakeHandler{}
		creds, err := handler.GetCredentials(nil)
		assert.NoError(t, err)
		assert.Equal(t, NoPermissions(), creds)
	})

	t.Run("should return explicitly set credentials", func(t *testing.T) {
		handler := &FakeHandler{&FakeCredentials{UserIDValue: "1"}}
		creds, err := handler.GetCredentials(nil)
		assert.NoError(t, err)
		assert.Equal(t, handler.Credentials, creds)
	})
}
