package data

import (
	"net/http"
	"testing"

	"code.justin.tv/extensions/configuration/services/main/protocol"
	"code.justin.tv/gds/gds/golibs/errors"
	"code.justin.tv/gds/gds/golibs/errors/errconv"
	"code.justin.tv/gds/gds/golibs/mocks"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

var expected = errors.NewBuilder("expected").Build()

func TestErrorConverter(t *testing.T) {
	conv := NewErrorConverter()
	assert.Equal(t, expected, conv.Convert(expected))
	assert.Equal(t, protocol.ErrConcurrency, conv.Convert(awserr.New(dynamodb.ErrCodeConditionalCheckFailedException, "x", nil)))
	assert.Equal(t, protocol.ErrTooManyRequests, conv.Convert(awserr.New(dynamodb.ErrCodeProvisionedThroughputExceededException, "x", nil)))
}

func TestStoreErrorConverter(t *testing.T) {
	r, err := http.NewRequest("GET", "/", nil)
	require.NoError(t, err)
	w := &mocks.ResponseWriter{}
	handler := StoreErrorConverter()
	inner := http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		assert.Equal(t, NewErrorConverter(), errconv.LoadConverter(r.Context()))
	})

	handler(inner).ServeHTTP(w, r)
}
