package bad

import (
	"testing"

	"code.justin.tv/extensions/configuration/services/main/data/model"
	"github.com/stretchr/testify/assert"
)

func TestStore(t *testing.T) {
	s := New()
	assert.IsType(t, model.NewErrorPromise(ErrExpected), s.AsyncLoadCommon("", ""))
	assert.IsType(t, model.NewErrorPromise(ErrExpected), s.AsyncLoadChannel("", "", ""))
	g, e := s.LoadCommon("", "")
	assert.Nil(t, g)
	assert.Equal(t, ErrExpected, e)
	c, e := s.LoadChannel("", "", "")
	assert.Nil(t, c)
	assert.Equal(t, ErrExpected, e)
	assert.Equal(t, ErrExpected, s.SaveCommon(g))
	assert.Equal(t, ErrExpected, s.SaveChannel(c))
	assert.Equal(t, ErrExpected, s.DeleteChannel(""))
	assert.Equal(t, ErrExpected, s.MarkCommonPublished(g))
	assert.Equal(t, ErrExpected, s.MarkChannelPublished(c))
	s.EnableDataReset()
	assert.False(t, s.IsResetEnabled())
	assert.Equal(t, ErrExpected, s.ResetAllData())
	assert.Equal(t, ErrExpected, s.Block(""))
	assert.Equal(t, ErrExpected, s.Unblock(""))
	assert.Equal(t, ErrExpected, s.OnDeletionFinished(""))
	assert.IsType(t, model.NewErrorPromise(ErrExpected), s.IsBlocked(""))
	l, e := s.DeletionInProgress()
	assert.Empty(t, l)
	assert.Equal(t, ErrExpected, e)
}
