package cached

import (
	"testing"
	"time"

	"code.justin.tv/extensions/configuration/services/main/data/model"
	"code.justin.tv/extensions/configuration/services/main/data/model/harness"
	"code.justin.tv/extensions/configuration/services/main/data/model/memory"
	"code.justin.tv/extensions/configuration/services/main/protocol"
	"code.justin.tv/gds/gds/golibs/uuid"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func create(src uuid.Source) (model.Store, model.BlockTracker) {
	mem := memory.New(src)
	return New(mem, time.Nanosecond), mem
}

func TestStore(t *testing.T) {
	harness.Store{}.RunTests(create, true, t)

	t.Run("should report invalid cache key", func(t *testing.T) {
		s, _ := create(uuid.NewSource())
		store := s.(*store)
		p := store.getForCache("?")
		require.False(t, p.WouldBlock())
		x, e := p.Get()
		assert.Nil(t, x)
		assert.Equal(t, protocol.ErrInvalidCacheKey, e)
	})

	t.Run("should handle invalid cache values", func(t *testing.T) {
		inner := memory.New(uuid.NewSource())
		store := New(inner, time.Hour).(*store)
		store.cache.Insert(commonKey("env", "extID"), 123)
		store.cache.Insert(channelKey("env", "extID", "chID"), 123)
		co, e := store.LoadCommon("env", "extID")
		assert.Nil(t, co)
		assert.Equal(t, protocol.ErrInvalidCacheContent, e)
		ch, e := store.LoadChannel("env", "extID", "chID")
		assert.Nil(t, ch)
		assert.Equal(t, protocol.ErrInvalidCacheContent, e)
	})
}
