package dynamo

import (
	"sync"

	"code.justin.tv/extensions/configuration/services/main/data/model"
	"code.justin.tv/extensions/configuration/services/main/data/model/shared"
	"code.justin.tv/gds/gds/golibs/dynamodb/aggregator"
)

type channelPromise struct {
	inner     aggregator.Promise
	block     model.BlockPromise
	unmarshal UnmarshalFunc
	once      sync.Once
	channel   *model.Channel
	err       error
}

func newChannelPromise(inner aggregator.Promise, block model.BlockPromise, unmarshal UnmarshalFunc) shared.BaseChannelPromise {
	return &channelPromise{inner: inner, block: block, unmarshal: unmarshal}
}

func (p *channelPromise) WouldBlock() bool          { return p.inner.WouldBlock() }
func (p *channelPromise) Get() (interface{}, error) { return p.Channel() }
func (p *channelPromise) Channel() (*model.Channel, error) {
	p.once.Do(p.resolve)
	return p.channel, p.err
}

func (p *channelPromise) resolve() {
	active, err := p.block.Active()
	if err != nil {
		p.err = err
	} else if !active {
		data, err := p.inner.GetData()
		if err != nil {
			p.err = err
		} else if len(data) > 0 {
			p.channel = new(model.Channel)
			p.err = p.unmarshal(data, p.channel)
		}
	}
}
