package dynamo

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"code.justin.tv/extensions/configuration/services/main/data/model"
	"code.justin.tv/extensions/configuration/services/main/data/model/bad"
	"code.justin.tv/gds/gds/golibs/dynamodb/lazy"
)

func TestCommonPromise(t *testing.T) {
	t.Run("should handle unset correctly", func(t *testing.T) {
		d := new(dummyPromise)
		d.block = true
		p := newCommonPromise(d, lazy.UnmarshalMap)
		assert.True(t, p.WouldBlock())
	})

	t.Run("should handle set correctly", func(t *testing.T) {
		src := model.NewCommon("env", "extID")
		d := new(dummyPromise)
		d.data, d.err = lazy.MarshalMap(src)
		p := newCommonPromise(d, lazy.UnmarshalMap)
		assert.False(t, p.WouldBlock())

		i, e := p.Get()
		assert.Equal(t, src, i)
		assert.NoError(t, e)

		out, e := p.Common()
		assert.Equal(t, src, out)
		assert.NoError(t, e)
	})

	t.Run("should handle empty correctly", func(t *testing.T) {
		d := new(dummyPromise)
		d.data, d.err = lazy.MarshalMap(nil)
		p := newCommonPromise(d, lazy.UnmarshalMap)
		assert.False(t, p.WouldBlock())
		i, e := p.Get()
		assert.Nil(t, i)
		assert.NoError(t, e)

		out, e := p.Common()
		assert.Nil(t, out)
		assert.NoError(t, e)
	})

	t.Run("should handle errored correctly", func(t *testing.T) {
		d := &dummyPromise{err: bad.ErrExpected}
		p := newCommonPromise(d, lazy.UnmarshalMap)
		assert.False(t, p.WouldBlock())
		i, e := p.Get()
		assert.Nil(t, i)
		assert.Equal(t, bad.ErrExpected, e)

		out, e := p.Common()
		assert.Nil(t, out)
		assert.Equal(t, bad.ErrExpected, e)
	})
}
