package dynamo

import (
	"time"

	"code.justin.tv/gds/gds/golibs/uuid"
	"github.com/aws/aws-sdk-go/service/dynamodb"
)

type MarshalFunc func(interface{}) (map[string]*dynamodb.AttributeValue, error)
type UnmarshalFunc func(map[string]*dynamodb.AttributeValue, interface{}) error

func MarshalForSave(input interface{}, uuid uuid.Source, marshaler MarshalFunc) (map[string]*dynamodb.AttributeValue, string, error) {
	next, err := uuid.Next()
	if err != nil {
		return nil, "", err
	}
	output, err := marshaler(input)
	if err != nil {
		return nil, "", err
	}

	// if there are serialized messages to publish
	if _, ok := output[fieldMessages]; ok {
		// we should always have an unpublished timestamp
		if _, ok := output[fieldUnpublished]; !ok {
			output[fieldUnpublished] = new(dynamodb.AttributeValue).SetS(time.Now().Format(time.RFC3339))
		}
	}

	// tables without a natural range key have a dummy inserted here
	if requiresRangeKey(output) {
		output[fieldRangeKey] = new(dynamodb.AttributeValue).SetS(fieldRangeKey)
	}
	output[fieldUUID] = new(dynamodb.AttributeValue).SetS(next)
	return output, next, err
}

func requiresRangeKey(values map[string]*dynamodb.AttributeValue) bool {
	if _, ok := values[fieldEnvironment]; ok {
		return false
	}
	if _, ok := values[fieldEnvAndExtID]; ok {
		return false
	}
	return true
}
