package dynamo

import (
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbiface"
)

type mockDynamo struct {
	dynamodbiface.DynamoDBAPI
	err error
}

func (m *mockDynamo) BatchGetItem(*dynamodb.BatchGetItemInput) (*dynamodb.BatchGetItemOutput, error) {
	var out dynamodb.BatchGetItemOutput
	return &out, m.err
}

func (m *mockDynamo) DescribeTable(*dynamodb.DescribeTableInput) (*dynamodb.DescribeTableOutput, error) {
	var out dynamodb.DescribeTableOutput
	return &out, m.err
}

func (m *mockDynamo) PutItem(*dynamodb.PutItemInput) (*dynamodb.PutItemOutput, error) {
	var out dynamodb.PutItemOutput
	return &out, m.err
}

func (m *mockDynamo) ScanPages(*dynamodb.ScanInput, func(*dynamodb.ScanOutput, bool) bool) error {
	return m.err
}

func (m *mockDynamo) UpdateItem(*dynamodb.UpdateItemInput) (*dynamodb.UpdateItemOutput, error) {
	var out dynamodb.UpdateItemOutput
	return &out, m.err
}
