package dynamo

import (
	"sync"
	"sync/atomic"

	"code.justin.tv/extensions/configuration/services/main/protocol"
	dynamo "code.justin.tv/gds/gds/golibs/dynamodb"
)

// note : these functions are part of *store, but placed here to keep file sizes
// sane
func (s *store) IsResetEnabled() bool { return atomic.LoadInt32(&s.resetEnabled) != 0 }
func (s *store) EnableDataReset()     { atomic.StoreInt32(&s.resetEnabled, 1) }
func (s *store) ResetAllData() error {
	if !s.IsResetEnabled() {
		return protocol.ErrUnavailable
	}
	errors := make(chan error, 3)
	var active sync.WaitGroup
	active.Add(3)
	go func() {
		defer active.Done()
		if err := dynamo.ClearTable(s.db, channelsTable(s.prefix), 1); err != nil {
			errors <- err
		}
	}()
	go func() {
		defer active.Done()
		if err := dynamo.ClearTable(s.db, commonTable(s.prefix), 1); err != nil {
			errors <- err
		}
	}()
	go func() {
		defer active.Done()
		if err := dynamo.ClearTable(s.db, blockTable(s.prefix), 1); err != nil {
			errors <- err
		}
	}()
	active.Wait()
	close(errors)
	var err error
	for err = range errors {
	}
	return err
}
