package model

import (
	"code.justin.tv/extensions/configuration/services/main/protocol"
)

// ErrorPromise wraps an error
type ErrorPromise struct {
	err error
}

var _ ChannelPromise = (*ErrorPromise)(nil)
var _ CommonPromise = (*ErrorPromise)(nil)
var _ RecordPromise = (*ErrorPromise)(nil)
var _ BlockPromise = (*ErrorPromise)(nil)

// NewErrorPromise creates a new promise that wraps an error
func NewErrorPromise(err error) *ErrorPromise { return &ErrorPromise{err} }

func (e *ErrorPromise) WouldBlock() bool                                      { return false }
func (e *ErrorPromise) Get() (interface{}, error)                             { return nil, e.err }
func (e *ErrorPromise) Record() (*protocol.Address, *protocol.Record, error)  { return nil, nil, e.err }
func (e *ErrorPromise) RecordMap() (protocol.RecordMap, error)                { return nil, e.err }
func (e *ErrorPromise) ForSegment(segment protocol.SegmentType) RecordPromise { return e }
func (e *ErrorPromise) Common() (*Common, error)                              { return nil, e.err }
func (e *ErrorPromise) Channel() (*Channel, error)                            { return nil, e.err }
func (e *ErrorPromise) Active() (bool, error)                                 { return false, e.err }
