package model

import (
	"testing"

	"code.justin.tv/extensions/configuration/services/main/protocol"
	"github.com/stretchr/testify/assert"
)

func TestPromise(t *testing.T) {
	p := NewErrorPromise(protocol.ErrUnauthorized)
	assert.False(t, p.WouldBlock())
	x, e := p.Get()
	assert.Nil(t, x)
	assert.Equal(t, protocol.ErrUnauthorized, e)
	x, r, e := p.Record()
	assert.Nil(t, x)
	assert.Nil(t, r)
	assert.Equal(t, protocol.ErrUnauthorized, e)
	x, e = p.RecordMap()
	assert.Nil(t, x)
	assert.Equal(t, protocol.ErrUnauthorized, e)
	x, e = p.Common()
	assert.Nil(t, x)
	assert.Equal(t, protocol.ErrUnauthorized, e)
	x, e = p.Channel()
	assert.Nil(t, x)
	assert.Equal(t, protocol.ErrUnauthorized, e)
	b, e := p.Active()
	assert.False(t, b)
	assert.Equal(t, protocol.ErrUnauthorized, e)
	assert.Equal(t, p, p.ForSegment(protocol.GlobalType))
}
