package memory

import (
	"code.justin.tv/extensions/configuration/services/main/data/model"
)

type blockPromise struct {
	active bool
	err    error
}

var _ model.BlockPromise = (*blockPromise)(nil)

func newBlockPromise(active bool, err error) *blockPromise {
	return &blockPromise{active, err}
}

func (*blockPromise) WouldBlock() bool            { return false }
func (b *blockPromise) Get() (interface{}, error) { return b.active, b.err }
func (b *blockPromise) Active() (bool, error)     { return b.active, b.err }
